/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Payments;

public class PaymentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getPaymentAccountLedgerEntryPaymentsCall(Long shopId, List<Long> ledgerEntryIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/payment-account/ledger-entries/payments".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ledgerEntryIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "ledger_entry_ids", ledgerEntryIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentAccountLedgerEntryPaymentsValidateBeforeCall(Long shopId, List<Long> ledgerEntryIds, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getPaymentAccountLedgerEntryPayments(Async)");
        }
        if (ledgerEntryIds == null) {
            throw new ApiException("Missing the required parameter 'ledgerEntryIds' when calling getPaymentAccountLedgerEntryPayments(Async)");
        }
        return this.getPaymentAccountLedgerEntryPaymentsCall(shopId, ledgerEntryIds, _callback);
    }

    public Payments getPaymentAccountLedgerEntryPayments(Long shopId, List<Long> ledgerEntryIds) throws ApiException {
        ApiResponse<Payments> localVarResp = this.getPaymentAccountLedgerEntryPaymentsWithHttpInfo(shopId, ledgerEntryIds);
        return localVarResp.getData();
    }

    public ApiResponse<Payments> getPaymentAccountLedgerEntryPaymentsWithHttpInfo(Long shopId, List<Long> ledgerEntryIds) throws ApiException {
        Call localVarCall = this.getPaymentAccountLedgerEntryPaymentsValidateBeforeCall(shopId, ledgerEntryIds, null);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPaymentAccountLedgerEntryPaymentsAsync(Long shopId, List<Long> ledgerEntryIds, ApiCallback<Payments> _callback) throws ApiException {
        Call localVarCall = this.getPaymentAccountLedgerEntryPaymentsValidateBeforeCall(shopId, ledgerEntryIds, _callback);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPaymentsCall(Long shopId, List<Long> paymentIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/payments".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (paymentIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_ids", paymentIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentsValidateBeforeCall(Long shopId, List<Long> paymentIds, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getPayments(Async)");
        }
        if (paymentIds == null) {
            throw new ApiException("Missing the required parameter 'paymentIds' when calling getPayments(Async)");
        }
        return this.getPaymentsCall(shopId, paymentIds, _callback);
    }

    public Payments getPayments(Long shopId, List<Long> paymentIds) throws ApiException {
        ApiResponse<Payments> localVarResp = this.getPaymentsWithHttpInfo(shopId, paymentIds);
        return localVarResp.getData();
    }

    public ApiResponse<Payments> getPaymentsWithHttpInfo(Long shopId, List<Long> paymentIds) throws ApiException {
        Call localVarCall = this.getPaymentsValidateBeforeCall(shopId, paymentIds, null);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPaymentsAsync(Long shopId, List<Long> paymentIds, ApiCallback<Payments> _callback) throws ApiException {
        Call localVarCall = this.getPaymentsValidateBeforeCall(shopId, paymentIds, _callback);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopPaymentByReceiptIdCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}/payments".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopPaymentByReceiptIdValidateBeforeCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopPaymentByReceiptId(Async)");
        }
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling getShopPaymentByReceiptId(Async)");
        }
        return this.getShopPaymentByReceiptIdCall(shopId, receiptId, _callback);
    }

    public Payments getShopPaymentByReceiptId(Long shopId, Long receiptId) throws ApiException {
        ApiResponse<Payments> localVarResp = this.getShopPaymentByReceiptIdWithHttpInfo(shopId, receiptId);
        return localVarResp.getData();
    }

    public ApiResponse<Payments> getShopPaymentByReceiptIdWithHttpInfo(Long shopId, Long receiptId) throws ApiException {
        Call localVarCall = this.getShopPaymentByReceiptIdValidateBeforeCall(shopId, receiptId, null);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopPaymentByReceiptIdAsync(Long shopId, Long receiptId, ApiCallback<Payments> _callback) throws ApiException {
        Call localVarCall = this.getShopPaymentByReceiptIdValidateBeforeCall(shopId, receiptId, _callback);
        Type localVarReturnType = new TypeToken<Payments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

