/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.PaymentAccountLedgerEntries;
import org.openapitools.client.model.PaymentAccountLedgerEntry;

public class LedgerEntryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public LedgerEntryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LedgerEntryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getShopPaymentAccountLedgerEntriesCall(Long shopId, Long minCreated, Long maxCreated, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/payment-account/ledger-entries".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (minCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_created", minCreated));
        }
        if (maxCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_created", maxCreated));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopPaymentAccountLedgerEntriesValidateBeforeCall(Long shopId, Long minCreated, Long maxCreated, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopPaymentAccountLedgerEntries(Async)");
        }
        if (minCreated == null) {
            throw new ApiException("Missing the required parameter 'minCreated' when calling getShopPaymentAccountLedgerEntries(Async)");
        }
        if (maxCreated == null) {
            throw new ApiException("Missing the required parameter 'maxCreated' when calling getShopPaymentAccountLedgerEntries(Async)");
        }
        return this.getShopPaymentAccountLedgerEntriesCall(shopId, minCreated, maxCreated, limit, offset, _callback);
    }

    public PaymentAccountLedgerEntries getShopPaymentAccountLedgerEntries(Long shopId, Long minCreated, Long maxCreated, Long limit, Long offset) throws ApiException {
        ApiResponse<PaymentAccountLedgerEntries> localVarResp = this.getShopPaymentAccountLedgerEntriesWithHttpInfo(shopId, minCreated, maxCreated, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<PaymentAccountLedgerEntries> getShopPaymentAccountLedgerEntriesWithHttpInfo(Long shopId, Long minCreated, Long maxCreated, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getShopPaymentAccountLedgerEntriesValidateBeforeCall(shopId, minCreated, maxCreated, limit, offset, null);
        Type localVarReturnType = new TypeToken<PaymentAccountLedgerEntries>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopPaymentAccountLedgerEntriesAsync(Long shopId, Long minCreated, Long maxCreated, Long limit, Long offset, ApiCallback<PaymentAccountLedgerEntries> _callback) throws ApiException {
        Call localVarCall = this.getShopPaymentAccountLedgerEntriesValidateBeforeCall(shopId, minCreated, maxCreated, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<PaymentAccountLedgerEntries>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopPaymentAccountLedgerEntryCall(Long shopId, Long ledgerEntryId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/payment-account/ledger-entries/{ledger_entry_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{ledger_entry_id}", this.localVarApiClient.escapeString(ledgerEntryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopPaymentAccountLedgerEntryValidateBeforeCall(Long shopId, Long ledgerEntryId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopPaymentAccountLedgerEntry(Async)");
        }
        if (ledgerEntryId == null) {
            throw new ApiException("Missing the required parameter 'ledgerEntryId' when calling getShopPaymentAccountLedgerEntry(Async)");
        }
        return this.getShopPaymentAccountLedgerEntryCall(shopId, ledgerEntryId, _callback);
    }

    public PaymentAccountLedgerEntry getShopPaymentAccountLedgerEntry(Long shopId, Long ledgerEntryId) throws ApiException {
        ApiResponse<PaymentAccountLedgerEntry> localVarResp = this.getShopPaymentAccountLedgerEntryWithHttpInfo(shopId, ledgerEntryId);
        return localVarResp.getData();
    }

    public ApiResponse<PaymentAccountLedgerEntry> getShopPaymentAccountLedgerEntryWithHttpInfo(Long shopId, Long ledgerEntryId) throws ApiException {
        Call localVarCall = this.getShopPaymentAccountLedgerEntryValidateBeforeCall(shopId, ledgerEntryId, null);
        Type localVarReturnType = new TypeToken<PaymentAccountLedgerEntry>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopPaymentAccountLedgerEntryAsync(Long shopId, Long ledgerEntryId, ApiCallback<PaymentAccountLedgerEntry> _callback) throws ApiException {
        Call localVarCall = this.getShopPaymentAccountLedgerEntryValidateBeforeCall(shopId, ledgerEntryId, _callback);
        Type localVarReturnType = new TypeToken<PaymentAccountLedgerEntry>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

