/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client;

import de.ameto.client.AmetoApi;
import de.ameto.client.AmetoException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class ProcessedAsset {
    private final String id;
    private final AmetoApi api;
    private InputStream essence;

    public InputStream getEssence() {
        if (this.essence == null) {
            Response getJobResult;
            try {
                getJobResult = this.api.getAssetEssence(this.id).execute();
            }
            catch (IOException e) {
                throw new AmetoException("Unable to fetch essence of asset " + this.id, e);
            }
            if (!getJobResult.isSuccessful()) {
                throw new AmetoException("Your job result could not be retrieved. It is possible that Ameto is experiencing a lot of traffic. Please try again later.");
            }
            Optional<Object> processedAssetResponseBody = Optional.ofNullable(getJobResult.body());
            this.essence = processedAssetResponseBody.map(ResponseBody::byteStream).orElseThrow(() -> new AmetoException("Received empty response for processed asset " + this.id));
        }
        return this.essence;
    }

    @ConstructorProperties(value={"id", "api"})
    public ProcessedAsset(String id, AmetoApi api) {
        this.id = id;
        this.api = api;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessedAsset)) {
            return false;
        }
        ProcessedAsset other = (ProcessedAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessedAsset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }
}

