/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.factory.ObjectMapperFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public final class ObjectToJsonExtensions {
    public static <T> String toJson(List<T> list) throws JsonGenerationException, JsonMappingException, IOException {
        Objects.requireNonNull(list);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper();
        return ObjectToJsonExtensions.toJson(list, mapper);
    }

    public static <T> String toJson(List<T> list, ObjectMapper mapper) throws IOException, JsonGenerationException, JsonMappingException {
        Objects.requireNonNull(list);
        Objects.requireNonNull(mapper);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, list);
        byte[] bytes = out.toByteArray();
        out.close();
        return new String(bytes);
    }

    public static <T> String toJson(T object) throws JsonProcessingException {
        Objects.requireNonNull(object);
        return ObjectToJsonExtensions.toJson(object, false);
    }

    public static <T> String toJson(T object, boolean newMapper) throws JsonProcessingException {
        Objects.requireNonNull(object);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(newMapper);
        return ObjectToJsonExtensions.toJson(object, mapper);
    }

    public static <T> String toJson(T object, ObjectMapper mapper) throws JsonProcessingException {
        Objects.requireNonNull(object);
        Objects.requireNonNull(mapper);
        return mapper.writeValueAsString(object);
    }

    private ObjectToJsonExtensions() {
    }
}

