/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.factory.ObjectMapperFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonStringToObjectExtensions {
    public static <K, V> Map<K, V> toMapObject(String jsonString, TypeReference<Map<K, V>> typeReference, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(mapper);
        return (Map)mapper.readValue(jsonString, typeReference);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, false);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, boolean newMapper) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(newMapper);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, mapper);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, Module ... modules) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(true);
        mapper = mapper.registerModules(modules);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, mapper);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(mapper);
        return (T)mapper.readValue(jsonString, clazz);
    }

    public static <T> T toObject(String jsonString, TypeReference<T> typeReference, ObjectMapper mapper) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(mapper);
        return (T)mapper.readValue(jsonString, typeReference);
    }

    public static <T> Collection<T> toObjectCollection(String jsonString, Class<? extends Collection> collectionClass, Class<T> elementClass) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(collectionClass);
        Objects.requireNonNull(elementClass);
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(true);
        return (Collection)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass));
    }

    public static <T> List<T> toObjectList(String jsonString, Class<T> elementClass) throws IOException {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(elementClass);
        return (List)JsonStringToObjectExtensions.toObjectCollection(jsonString, List.class, elementClass);
    }

    private JsonStringToObjectExtensions() {
    }
}

