/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.crypto.file;

import com.thoughtworks.xstream.XStream;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.file.write.WriteFileExtensions;
import de.alpharogroup.xml.ObjectToXmlExtensions;
import de.alpharogroup.xml.factory.XStreamFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;

public final class XmlEncryptionExtensions {
    public static <T> void writeToFileAsXmlAndHex(Map<String, Class<?>> aliases, T data, File file, String ... allowTypesByWildcard) throws IOException {
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        XStream xStream = XStreamFactory.newXStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        XStreamFactory.newXStream(xStream, aliases, allowTypesByWildcard);
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(xStream, aliases, data, file);
    }

    public static <T> void writeToFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, T data, File file) throws IOException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(xstream, aliases, data, file, "UTF-8");
    }

    public static <T> void writeToFileAsXmlAndHex(XStream xstream, Map<String, Class<?>> aliases, T data, File file, String charset) throws IOException {
        Objects.requireNonNull(xstream);
        Objects.requireNonNull(aliases);
        Objects.requireNonNull(data);
        Objects.requireNonNull(file);
        String xmlString = ObjectToXmlExtensions.toXmlWithXStream(xstream, data, aliases);
        String hexXmlString = HexExtensions.encodeHex((String)xmlString, (Charset)Charset.forName(charset), (boolean)true);
        WriteFileExtensions.writeStringToFile((File)file, (String)hexXmlString, (String)charset);
    }

    private XmlEncryptionExtensions() {
    }
}

