/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.XStream;
import de.alpharogroup.xml.factory.XStreamFactory;
import de.alpharogroup.xml.factory.XmlMapperFactory;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Objects;

public final class XmlToObjectExtensions {
    public static <T> T toObjectWithJackson(String xmlString, Class<T> clazz) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(clazz);
        return (T)XmlMapperFactory.newXmlMapper().readValue(xmlString, clazz);
    }

    public static <T> T toObjectWithJackson(String xmlString, TypeReference<T> typeReference) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(typeReference);
        return XmlToObjectExtensions.toObjectWithJackson(xmlString, typeReference, XmlMapperFactory.newXmlMapper());
    }

    public static <T> T toObjectWithJackson(String xmlString, TypeReference<T> typeReference, ObjectMapper xmlMapper) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(xmlMapper);
        return (T)xmlMapper.readValue(xmlString, typeReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T toObjectWithXMLDecoder(String xmlString) {
        Object obj;
        try (XMLDecoder dec = null;){
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            dec = new XMLDecoder(is);
            obj = dec.readObject();
        }
        return (T)obj;
    }

    public static <T> T toObjectWithXStream(String xmlString) {
        return XmlToObjectExtensions.toObjectWithXStream(null, xmlString);
    }

    public static <T> T toObjectWithXStream(String xmlString, Map<String, Class<?>> aliases) {
        return XmlToObjectExtensions.toObjectWithXStream(null, xmlString, aliases);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xmlString) {
        return XmlToObjectExtensions.toObjectWithXStream(xstream, xmlString, null);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xmlString, Map<String, Class<?>> aliases) {
        xstream = XStreamFactory.initializeXStream(xstream, aliases);
        return (T)xstream.fromXML(xmlString);
    }

    private XmlToObjectExtensions() {
    }
}

