/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import de.alpharogroup.xml.XmlToObjectExtensions;
import de.alpharogroup.xml.json.ObjectToJsonExtensions;
import java.util.Map;
import java.util.Objects;

public final class XmlToJsonExtensions {
    public static String toJson(String xmlString) {
        return XmlToJsonExtensions.toJson(xmlString, null);
    }

    public static String toJson(String xmlString, Map<String, Class<?>> aliases) {
        Object object = XmlToObjectExtensions.toObjectWithXStream(xmlString);
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        String json = xstream.toXML(object);
        return json;
    }

    public static <T> String toJsonWithJackson(String xmlString, Class<T> clazz) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(clazz);
        T object = XmlToObjectExtensions.toObjectWithJackson(xmlString, clazz);
        String json = ObjectToJsonExtensions.toJson(object);
        return json;
    }

    private XmlToJsonExtensions() {
    }
}

