/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.xml.XmlToObjectExtensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.xml.sax.InputSource;

public final class XmlExtensions {
    public static InputSource getInputSource(String xmlString) {
        return new InputSource(new StringReader(xmlString));
    }

    public static <T> T loadObject(File xmlFile) throws IOException {
        FileInputStream is = FileUtils.openInputStream((File)xmlFile);
        return XmlExtensions.loadObject(is);
    }

    public static <T> T loadObject(File xmlFile, Class<T> clazz) throws IOException {
        Objects.requireNonNull(clazz);
        FileInputStream is = FileUtils.openInputStream((File)xmlFile);
        return XmlExtensions.loadObject(is, clazz);
    }

    private static <T> T loadObject(InputStream is) throws IOException {
        String xmlString = ReadFileExtensions.inputStream2String((InputStream)is);
        Object object = XmlToObjectExtensions.toObjectWithXStream(xmlString);
        return object;
    }

    private static <T> T loadObject(InputStream is, Class<T> clazz) throws IOException {
        Objects.requireNonNull(is);
        Objects.requireNonNull(clazz);
        String xmlString = ReadFileExtensions.inputStream2String((InputStream)is);
        T object = XmlToObjectExtensions.toObjectWithJackson(xmlString, clazz);
        return object;
    }

    public static <T> T loadObject(String xmlFileName) throws IOException {
        InputStream is = ClassExtensions.getResourceAsStream((String)xmlFileName);
        return XmlExtensions.loadObject(is);
    }

    public static <T> T loadObject(String xmlFileName, Class<T> clazz) throws IOException {
        Objects.requireNonNull(clazz);
        InputStream is = ClassExtensions.getResourceAsStream((String)xmlFileName);
        return XmlExtensions.loadObject(is, clazz);
    }

    public static String newTag(String tagname, String value, Map<String, String> attributes) {
        StringBuilder xmlTag = new StringBuilder();
        xmlTag.append("<").append(tagname);
        if (attributes != null && !attributes.isEmpty()) {
            xmlTag.append(" ");
            int count = 1;
            for (Map.Entry<String, String> attributte : attributes.entrySet()) {
                xmlTag.append(attributte.getKey());
                xmlTag.append("=");
                xmlTag.append("\"").append(attributte.getValue()).append("\"");
                if (count != attributes.size()) {
                    xmlTag.append(" ");
                }
                ++count;
            }
        }
        xmlTag.append(">");
        xmlTag.append(value);
        xmlTag.append("</").append(tagname).append(">");
        return xmlTag.toString();
    }

    private XmlExtensions() {
    }
}

