/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.XStream;
import de.alpharogroup.xml.factory.XStreamFactory;
import de.alpharogroup.xml.factory.XmlMapperFactory;
import java.util.Map;
import java.util.Objects;

public final class ObjectToXmlExtensions {
    public static <T> String toXmlWithJackson(T objectToXML) throws JsonProcessingException {
        Objects.requireNonNull(objectToXML);
        ObjectMapper xmlMapper = XmlMapperFactory.newXmlMapper();
        return xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectToXML);
    }

    public static <T> String toXmlWithXStream(T objectToXML) {
        return ObjectToXmlExtensions.toXmlWithXStream(null, objectToXML);
    }

    public static <T> String toXmlWithXStream(T objectToXML, Map<String, Class<?>> aliases) {
        return ObjectToXmlExtensions.toXmlWithXStream(null, objectToXML, aliases);
    }

    public static <T> String toXmlWithXStream(XStream xstream, T objectToXML) {
        return ObjectToXmlExtensions.toXmlWithXStream(xstream, objectToXML, null);
    }

    public static <T> String toXmlWithXStream(XStream xstream, T objectToXML, Map<String, Class<?>> aliases) {
        xstream = XStreamFactory.initializeXStream(xstream, aliases);
        return xstream.toXML(objectToXML);
    }

    private ObjectToXmlExtensions() {
    }
}

