/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.to.xsd;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;
import org.apache.xmlbeans.impl.inst2xsd.Inst2XsdOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

public final class XmlToXsdExtensions {
    public static String xmlToXsd(File xmlFile) throws XmlException, IOException {
        return XmlToXsdExtensions.xmlToXsd(xmlFile, new Inst2XsdOptions());
    }

    public static void xmlToXsd(File xmlInputFile, File xsdOutFile) throws XmlException, IOException {
        XmlToXsdExtensions.xmlToXsd(xmlInputFile, xsdOutFile, new Inst2XsdOptions());
    }

    public static void xmlToXsd(File xmlInputFile, File xsdOutFile, Inst2XsdOptions inst2XsdOptions) throws XmlException, IOException {
        XmlToXsdExtensions.xmlToXsd(xmlInputFile, xsdOutFile, inst2XsdOptions, new XmlOptions().setSavePrettyPrint());
    }

    public static void xmlToXsd(File xmlFile, File xsdOutFile, Inst2XsdOptions inst2XsdOptions, XmlOptions xmlOptions) throws XmlException, IOException {
        XmlObject[] xmlInstances = new XmlObject[]{XmlObject.Factory.parse((File)xmlFile)};
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xmlInstances, (Inst2XsdOptions)inst2XsdOptions);
        SchemaDocument schema = schemaDocs[0];
        schema.save(xsdOutFile, xmlOptions);
    }

    public static String xmlToXsd(File xmlFile, Inst2XsdOptions inst2XsdOptions) throws XmlException, IOException {
        return XmlToXsdExtensions.xmlToXsd(xmlFile, inst2XsdOptions, new XmlOptions().setSavePrettyPrint());
    }

    public static String xmlToXsd(File xmlFile, Inst2XsdOptions inst2XsdOptions, XmlOptions xmlOptions) throws XmlException, IOException {
        XmlObject[] xmlInstances = new XmlObject[]{XmlObject.Factory.parse((File)xmlFile)};
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xmlInstances, (Inst2XsdOptions)inst2XsdOptions);
        SchemaDocument schema = schemaDocs[0];
        return schema.xmlText(xmlOptions);
    }

    public static void xmlToXsd(File[] xmlFiles, Inst2XsdOptions inst2XsdOptions, File outDir, String outPrefix) throws IOException {
        if (xmlFiles == null || xmlFiles.length == 0) {
            throw new IllegalArgumentException("XML file array can not be null and not empty.");
        }
        if (outDir == null) {
            outDir = new File(".");
        }
        if (outPrefix == null) {
            outPrefix = "schema";
        }
        XmlObject[] xmlInstances = new XmlObject[xmlFiles.length];
        int i = 0;
        try {
            for (i = 0; i < xmlFiles.length; ++i) {
                xmlInstances[i] = XmlObject.Factory.parse((File)xmlFiles[i]);
            }
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("Invalid xml file: '" + xmlFiles[i].getName() + "'. \n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file: '" + xmlFiles[i].getName() + "'. " + e.getMessage(), e);
        }
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xmlInstances, (Inst2XsdOptions)inst2XsdOptions);
        try {
            for (i = 0; i < schemaDocs.length; ++i) {
                SchemaDocument schema = schemaDocs[i];
                schema.save(new File(outDir, outPrefix + i + ".xsd"), new XmlOptions().setSavePrettyPrint());
            }
        }
        catch (IOException e) {
            throw new IOException("Could not write file: '" + outDir + File.pathSeparator + outPrefix + i + ".xsd'. " + e.getMessage(), e);
        }
    }

    public static String xmlToXsd(String xmlFile, Inst2XsdOptions inst2XsdOptions, XmlOptions xmlOptions) throws XmlException, IOException {
        XmlObject[] xmlInstances = new XmlObject[]{XmlObject.Factory.parse((String)xmlFile)};
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xmlInstances, (Inst2XsdOptions)inst2XsdOptions);
        SchemaDocument schema = schemaDocs[0];
        StringWriter writer = new StringWriter();
        schema.save((Writer)writer, xmlOptions);
        return writer.toString();
    }

    private XmlToXsdExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

