/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.json.ObjectMapperFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import lombok.NonNull;

public final class ObjectToJsonExtensions {
    public static <T> String toJson(@NonNull List<T> list) throws JsonGenerationException, JsonMappingException, IOException {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        ObjectMapper mapper = new ObjectMapper();
        return ObjectToJsonExtensions.toJson(list, mapper);
    }

    public static <T> String toJson(@NonNull List<T> list, @NonNull ObjectMapper mapper) throws IOException, JsonGenerationException, JsonMappingException {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, list);
        byte[] bytes = out.toByteArray();
        out.close();
        return new String(bytes);
    }

    public static <T> String toJson(@NonNull T object) throws JsonProcessingException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return ObjectToJsonExtensions.toJson(object, false);
    }

    public static <T> String toJson(@NonNull T object, boolean newMapper) throws JsonProcessingException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(newMapper);
        return ObjectToJsonExtensions.toJson(object, mapper);
    }

    public static <T> String toJson(@NonNull T object, @NonNull ObjectMapper mapper) throws JsonProcessingException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return mapper.writeValueAsString(object);
    }

    private ObjectToJsonExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

