/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.json.ObjectMapperFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

public final class JsonStringToObjectExtensions {
    public static <T> T toObject(@NonNull String jsonString, @NonNull Class<T> clazz) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, false);
    }

    public static <T> T toObject(@NonNull String jsonString, @NonNull Class<T> clazz, boolean newMapper) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(newMapper);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, mapper);
    }

    public static <T> T toObject(@NonNull String jsonString, @NonNull Class<T> clazz, Module ... modules) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(true);
        mapper = mapper.registerModules(modules);
        return JsonStringToObjectExtensions.toObject(jsonString, clazz, mapper);
    }

    public static <T> T toObject(@NonNull String jsonString, @NonNull Class<T> clazz, @NonNull ObjectMapper mapper) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return (T)mapper.readValue(jsonString, clazz);
    }

    public static <T> List<T> toObjectList(@NonNull String jsonString, @NonNull Class<T> elementClass) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (elementClass == null) {
            throw new NullPointerException("elementClass is marked non-null but is null");
        }
        return (List)JsonStringToObjectExtensions.toObjectCollection(jsonString, List.class, elementClass);
    }

    public static <T> Collection<T> toObjectCollection(@NonNull String jsonString, @NonNull Class<? extends Collection> collectionClass, @NonNull Class<T> elementClass) throws IOException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        if (collectionClass == null) {
            throw new NullPointerException("collectionClass is marked non-null but is null");
        }
        if (elementClass == null) {
            throw new NullPointerException("elementClass is marked non-null but is null");
        }
        ObjectMapper mapper = ObjectMapperFactory.newObjectMapper(true);
        return (Collection)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass));
    }

    private JsonStringToObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

