/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;

public final class JsonFileToObjectExtensions {
    public static <T> T toObject(@NonNull File jsonFile, @NonNull Class<T> clazz, @NonNull ObjectMapper mapper) throws IOException {
        if (jsonFile == null) {
            throw new NullPointerException("jsonFile is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return (T)mapper.readValue(jsonFile, clazz);
    }

    public static <T> T toObject(@NonNull File jsonFile, @NonNull TypeReference<T> typeReference, @NonNull ObjectMapper mapper) throws IOException {
        if (jsonFile == null) {
            throw new NullPointerException("jsonFile is marked non-null but is null");
        }
        if (typeReference == null) {
            throw new NullPointerException("typeReference is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return (T)mapper.readValue(jsonFile, typeReference);
    }

    private JsonFileToObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

