/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.xml.json.JsonStringToObjectExtensions;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JSONObjectToObjectExtensions {
    public static <T> T toObject(@NonNull JSONObject jsonObject, @NonNull Class<T> clazz, @NonNull ObjectMapper mapper) throws IOException {
        if (jsonObject == null) {
            throw new NullPointerException("jsonObject is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return JsonStringToObjectExtensions.toObject(jsonObject.toString(), clazz, mapper);
    }

    public static <T> List<T> toObjectList(@NonNull JSONArray jsonArray, @NonNull Class<T> elementClass) throws IOException {
        if (jsonArray == null) {
            throw new NullPointerException("jsonArray is marked non-null but is null");
        }
        if (elementClass == null) {
            throw new NullPointerException("elementClass is marked non-null but is null");
        }
        List list = ListFactory.newArrayList((Object[])new String[0]);
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object object = jsonArray.get(i);
            list.add(object.toString());
        }
        List result = ListFactory.newArrayList((Object[])new Object[0]);
        for (int i = 0; i < list.size(); ++i) {
            result.add(JsonStringToObjectExtensions.toObject((String)list.get(i), elementClass));
        }
        return result;
    }

    private JSONObjectToObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

