/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.crypto.file;

import com.thoughtworks.xstream.XStream;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.file.write.WriteFileExtensions;
import de.alpharogroup.xml.ObjectToXmlExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.NonNull;

public final class XmlEncryptionExtensions {
    public static <T> void writeToFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull T data, @NonNull File file) throws IOException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(xstream, aliases, data, file, "UTF-8");
    }

    public static <T> void writeToFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull T data, @NonNull File file, String charset) throws IOException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String xmlString = ObjectToXmlExtensions.toXmlWithXStream(xstream, data, aliases);
        String hexXmlString = HexExtensions.encodeHex((String)xmlString, (Charset)Charset.forName(charset), (boolean)true);
        WriteFileExtensions.writeStringToFile((File)file, (String)hexXmlString, (String)charset);
    }

    public static <T> void writeToFileAsXmlAndHex(@NonNull Map<String, Class<?>> aliases, @NonNull T data, @NonNull File file, String ... allowTypesByWildcard) throws IOException {
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(allowTypesByWildcard);
        XmlEncryptionExtensions.writeToFileAsXmlAndHex(xStream, aliases, data, file);
    }

    private XmlEncryptionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

