/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.crypto.file;

import com.thoughtworks.xstream.XStream;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.xml.XmlToObjectExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.codec.DecoderException;

public final class XmlDecryptionExtensions {
    public static <T> T readFromFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull File selectedFile, String charset) throws IOException, DecoderException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (selectedFile == null) {
            throw new NullPointerException("selectedFile is marked non-null but is null");
        }
        String hexXmlString = ReadFileExtensions.readFromFile((File)selectedFile, (Charset)Charset.forName(charset));
        String xmlString = HexExtensions.decodeHex((String)hexXmlString);
        return XmlToObjectExtensions.toObjectWithXStream(xstream, xmlString, aliases);
    }

    public static <T> T readFromFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull File selectedFile) throws IOException, DecoderException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (selectedFile == null) {
            throw new NullPointerException("selectedFile is marked non-null but is null");
        }
        return XmlDecryptionExtensions.readFromFileAsXmlAndHex(xstream, aliases, selectedFile, "UTF-8");
    }

    public static <T> T readFromFileAsXmlAndHex(@NonNull Map<String, Class<?>> aliases, @NonNull File selectedFile, String ... allowTypesByWildcard) throws IOException, DecoderException {
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (selectedFile == null) {
            throw new NullPointerException("selectedFile is marked non-null but is null");
        }
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(allowTypesByWildcard);
        return XmlDecryptionExtensions.readFromFileAsXmlAndHex(xStream, aliases, selectedFile);
    }

    private XmlDecryptionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

