/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import com.thoughtworks.xstream.XStream;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.Map;

public final class XmlToObjectExtensions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T toObjectWithXMLDecoder(String xmlString) {
        Object obj = null;
        try (XMLDecoder dec = null;){
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            dec = new XMLDecoder(is);
            obj = dec.readObject();
        }
        return (T)obj;
    }

    public static <T> T toObjectWithXStream(String xmlString) {
        return XmlToObjectExtensions.toObjectWithXStream(null, xmlString);
    }

    public static <T> T toObjectWithXStream(String xmlString, Map<String, Class<?>> aliases) {
        return XmlToObjectExtensions.toObjectWithXStream(null, xmlString, aliases);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xmlString) {
        return XmlToObjectExtensions.toObjectWithXStream(xstream, xmlString, null);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xmlString, Map<String, Class<?>> aliases) {
        xstream = XmlToObjectExtensions.initializeXStream(xstream, aliases);
        return (T)xstream.fromXML(xmlString);
    }

    public static XStream initializeXStream(XStream xstream, Map<String, Class<?>> aliases) {
        if (xstream == null) {
            xstream = new XStream();
        }
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        return xstream;
    }

    private XmlToObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

