/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.json.ObjectMapperFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public final class JsonToObjectExtensions {
    public static <T> T toObject(String jsonString, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return JsonToObjectExtensions.toObject(jsonString, clazz, false);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, boolean newMapper) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper(newMapper);
        Object object = mapper.readValue(jsonString, clazz);
        return (T)object;
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, Module ... modules) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper(true);
        mapper = mapper.registerModules(modules);
        Object object = mapper.readValue(jsonString, clazz);
        return (T)object;
    }

    public static <T> List<T> toObjectList(String jsonString, Class<T> elementClass) throws JsonParseException, JsonMappingException, IOException {
        return (List)JsonToObjectExtensions.toObjectCollection(jsonString, List.class, elementClass);
    }

    public static <T> Collection<T> toObjectCollection(String jsonString, Class<? extends Collection> collectionClass, Class<T> elementClass) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper(true);
        return (Collection)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass));
    }

    private JsonToObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

