/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xsd.schema;

import de.alpharogroup.xsd.schema.ValidatorHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ValidatorUtils {
    protected static final Logger logger = Logger.getLogger(ValidatorUtils.class);
    private static final String DOCUMENT_BUILDER_FACTORY_VALUE = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String DOCUMENT_BUILDER_FACTORY_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String SCHEMA_SOURCE_KEY = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA_LANGUAGE_KEY = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String HTTP_WWW_W3_ORG_2001_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static DocumentBuilderFactory getDocumentBuilderFactory(String schema) {
        System.setProperty(DOCUMENT_BUILDER_FACTORY_KEY, DOCUMENT_BUILDER_FACTORY_VALUE);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(SCHEMA_LANGUAGE_KEY, HTTP_WWW_W3_ORG_2001_XML_SCHEMA);
        factory.setAttribute(SCHEMA_SOURCE_KEY, schema);
        return factory;
    }

    public static DOMSource getDOMSource(File xml, ErrorHandler errorHandler) throws SAXException, ParserConfigurationException, IOException {
        return new DOMSource(ValidatorUtils.parse(xml, errorHandler));
    }

    public static Schema getSchema(File xsd, ErrorHandler errorHandler) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(HTTP_WWW_W3_ORG_2001_XML_SCHEMA);
        schemaFactory.setErrorHandler(errorHandler);
        return schemaFactory.newSchema(xsd);
    }

    public static Document parse(File xml, ErrorHandler errorHandler) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = ValidatorUtils.getDocumentBuilderFactory(xml.getName());
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(errorHandler);
        return builder.parse(xml);
    }

    public static void validateSchema(File xsd, File xml, ErrorHandler errorHandler) throws SAXException, ParserConfigurationException, IOException {
        Schema schemaXSD = ValidatorUtils.getSchema(xsd, errorHandler);
        Validator validator = schemaXSD.newValidator();
        validator.validate(ValidatorUtils.getDOMSource(xml, errorHandler));
    }

    public static boolean validateSchema(String SchemaUrl, String XmlDocumentUrl) throws SAXException, ParserConfigurationException, IOException {
        System.setProperty(DOCUMENT_BUILDER_FACTORY_KEY, DOCUMENT_BUILDER_FACTORY_VALUE);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(SCHEMA_LANGUAGE_KEY, HTTP_WWW_W3_ORG_2001_XML_SCHEMA);
        factory.setAttribute(SCHEMA_SOURCE_KEY, SchemaUrl);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ValidatorHandler handler = new ValidatorHandler();
        builder.setErrorHandler(handler);
        builder.parse(XmlDocumentUrl);
        return !handler.isValid();
    }
}

