/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.sax.handler;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class WriterHandler
extends DefaultHandler {
    private StringBuffer stringBuffer;
    private final Writer writer;

    public WriterHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer(s);
        } else {
            this.stringBuffer.append(s);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.insertNewLine();
        try {
            this.insertNewLine();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String simpleName, String qualifiedName) throws SAXException {
        this.writeToBuffer();
        String elementName = simpleName;
        if ("".equals(elementName)) {
            elementName = qualifiedName;
        }
        this.write("</" + elementName + ">");
    }

    public Writer getWriter() {
        return this.writer;
    }

    private void insertNewLine() throws SAXException {
        try {
            this.writer.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.write("<?xml version='1.0' encoding='UTF-8'?>");
        this.insertNewLine();
    }

    @Override
    public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attributes) throws SAXException {
        this.writeToBuffer();
        String elementName = simpleName;
        if ("".equals(elementName)) {
            elementName = qualifiedName;
        }
        this.write("<" + elementName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getLocalName(i);
                if ("".equals(attributeName)) {
                    attributeName = attributes.getQName(i);
                }
                this.write(" ");
                this.write(attributeName + "=\"" + attributes.getValue(i) + "\"");
            }
        }
        this.write(">");
    }

    protected abstract void write(String var1) throws SAXException;

    private void writeToBuffer() throws SAXException {
        if (this.stringBuffer == null) {
            return;
        }
        String s = "" + this.stringBuffer;
        this.write(s);
        this.stringBuffer = null;
    }
}

