/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.Map;
import org.xml.sax.InputSource;

public final class XmlExtensions {
    public static InputSource getInputSource(String xmlString) {
        return new InputSource(new StringReader(xmlString));
    }

    public static String newTag(String tagname, String value, Map<String, String> attributtes) {
        StringBuilder xmlTag = new StringBuilder();
        xmlTag.append("<").append(tagname);
        if (attributtes != null && !attributtes.isEmpty()) {
            xmlTag.append(" ");
            int count = 1;
            for (Map.Entry<String, String> attributte : attributtes.entrySet()) {
                xmlTag.append(attributte.getKey());
                xmlTag.append("=");
                xmlTag.append("\"").append(attributte.getValue()).append("\"");
                if (count != attributtes.size()) {
                    xmlTag.append(" ");
                }
                ++count;
            }
        }
        xmlTag.append(">");
        xmlTag.append(value);
        xmlTag.append("</").append(tagname).append(">");
        return xmlTag.toString();
    }

    public static String toJson(String xml) {
        return XmlExtensions.toJson(xml, null);
    }

    public static String toJson(String xml, Map<String, Class<?>> aliases) {
        Object object = XmlExtensions.toObjectWithXStream(xml);
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        String json = xstream.toXML(object);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T toObjectWithXMLDecoder(String xmlString) {
        Object obj = null;
        try (XMLDecoder dec = null;){
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            dec = new XMLDecoder(is);
            obj = dec.readObject();
        }
        return (T)obj;
    }

    public static <T> T toObjectWithXStream(String xml) {
        return XmlExtensions.toObjectWithXStream(null, xml);
    }

    public static <T> T toObjectWithXStream(String xml, Map<String, Class<?>> aliases) {
        return XmlExtensions.toObjectWithXStream(null, xml, aliases);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xml) {
        return XmlExtensions.toObjectWithXStream(xstream, xml, null);
    }

    public static <T> T toObjectWithXStream(XStream xstream, String xml, Map<String, Class<?>> aliases) {
        if (xstream == null) {
            xstream = new XStream();
        }
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        return (T)xstream.fromXML(xml);
    }

    public static <T> String toXmlWithXMLEncoder(T obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (XMLEncoder enc = null;){
            enc = new XMLEncoder(baos);
            enc.writeObject(obj);
            enc.close();
            enc = null;
        }
        return baos.toString();
    }

    public static <T> String toXmlWithXStream(T objectToXML) {
        return XmlExtensions.toXmlWithXStream(null, objectToXML);
    }

    public static <T> String toXmlWithXStream(T objectToXML, Map<String, Class<?>> aliases) {
        return XmlExtensions.toXmlWithXStream(null, objectToXML, aliases);
    }

    public static <T> String toXmlWithXStream(XStream xstream, T objectToXML) {
        return XmlExtensions.toXmlWithXStream(xstream, objectToXML, null);
    }

    public static <T> String toXmlWithXStream(XStream xstream, T objectToXML, Map<String, Class<?>> aliases) {
        if (xstream == null) {
            xstream = new XStream();
        }
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        String xml = xstream.toXML(objectToXML);
        return xml;
    }

    private XmlExtensions() {
    }
}

