/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.bootstrap3.application;

import com.google.javascript.jscomp.CompilationLevel;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.RenderJavaScriptToFooterHeaderResponseDecorator;
import de.agilecoders.wicket.core.markup.html.bootstrap.block.prettyprint.PrettifyCssResourceReference;
import de.agilecoders.wicket.core.markup.html.bootstrap.block.prettyprint.PrettifyJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.references.ModernizrJavaScriptReference;
import de.agilecoders.wicket.core.request.resource.caching.version.Adler32ResourceVersion;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.Theme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.extensions.javascript.GoogleClosureJavaScriptCompressor;
import de.agilecoders.wicket.extensions.javascript.YuiCssCompressor;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.OpenWebIconsCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUICoreJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUIDraggableJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUIMouseJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUIResizableJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUIWidgetJavaScriptReference;
import de.agilecoders.wicket.extensions.request.StaticResourceRewriteMapper;
import de.agilecoders.wicket.less.BootstrapLess;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import de.alpharogroup.wicket.base.application.seo.DisableJSessionIDinUrlApplication;
import de.alpharogroup.wicket.bootstrap3.resource.reference.fix.FixBootstrapStylesCssResourceReference;
import java.io.IOException;
import java.util.Properties;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.caching.FilenameWithVersionResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.NoOpResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.DeflatedJavaSerializer;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.annotation.scan.AnnotatedMountScanner;

public abstract class WicketBootstrap3Application
extends DisableJSessionIDinUrlApplication {
    private Properties properties = this.loadProperties();
    public static final String FOOTER_FILTER_NAME = "footer-container";

    public static WicketBootstrap3Application get() {
        return (WicketBootstrap3Application)Application.get();
    }

    public void init() {
        super.init();
        this.getApplicationSettings().setUploadProgressUpdatesEnabled(true);
        this.configureBootstrap();
        this.configureResourceBundles();
        this.optimizeForWebPerformance();
        new AnnotatedMountScanner().scanPackage(this.getPackageToScan()).mount((WebApplication)this);
        if (Strings.isTrue((String)this.properties.getProperty("cdn.useCdn"))) {
            String cdn = this.properties.getProperty("cdn.baseUrl");
            StaticResourceRewriteMapper.withBaseUrl((String)cdn).install((WebApplication)this);
        }
    }

    public abstract String getPackageToScan();

    private void optimizeForWebPerformance() {
        if (this.usesDeploymentConfig()) {
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new FilenameWithVersionResourceCachingStrategy("-v-", (IResourceVersion)new CachingResourceVersion((IResourceVersion)new Adler32ResourceVersion())));
            this.getResourceSettings().setJavaScriptCompressor((IJavaScriptCompressor)new GoogleClosureJavaScriptCompressor(CompilationLevel.SIMPLE_OPTIMIZATIONS));
            this.getResourceSettings().setCssCompressor((ICssCompressor)new YuiCssCompressor());
            this.getFrameworkSettings().setSerializer((ISerializer)new DeflatedJavaSerializer(this.getApplicationKey()));
        } else {
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new NoOpResourceCachingStrategy());
        }
        this.setHeaderResponseDecorator((IHeaderResponseDecorator)new RenderJavaScriptToFooterHeaderResponseDecorator());
        this.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.ONE_PASS_RENDER);
    }

    private void configureResourceBundles() {
        this.getResourceBundles().addJavaScriptBundle(WicketBootstrap3Application.class, "core.js", new JavaScriptResourceReference[]{(JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getJQueryReference(), (JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getWicketEventReference(), (JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getWicketAjaxReference(), ModernizrJavaScriptReference.instance()});
        this.getResourceBundles().addJavaScriptBundle(WicketBootstrap3Application.class, "bootstrap.js", new JavaScriptResourceReference[]{(JavaScriptResourceReference)Bootstrap.getSettings().getJsResourceReference(), (JavaScriptResourceReference)PrettifyJavaScriptReference.INSTANCE});
        this.getResourceBundles().addJavaScriptBundle(WicketBootstrap3Application.class, "bootstrap-extensions.js", new JavaScriptResourceReference[]{JQueryUICoreJavaScriptReference.instance(), JQueryUIWidgetJavaScriptReference.instance(), JQueryUIMouseJavaScriptReference.instance(), JQueryUIDraggableJavaScriptReference.instance(), JQueryUIResizableJavaScriptReference.instance(), Html5PlayerJavaScriptReference.instance()});
        this.getResourceBundles().addCssBundle(WicketBootstrap3Application.class, "bootstrap-extensions.css", new CssResourceReference[]{Html5PlayerCssReference.instance(), OpenWebIconsCssReference.instance()});
        this.getResourceBundles().addCssBundle(WicketBootstrap3Application.class, "application.css", new CssResourceReference[]{(CssResourceReference)PrettifyCssResourceReference.INSTANCE, FixBootstrapStylesCssResourceReference.INSTANCE});
    }

    protected void configureBootstrap() {
        this.configureBootstrap(this.newThemeProvider());
    }

    protected void configureBootstrap(ThemeProvider themeProvider) {
        this.initBootstrap(themeProvider);
    }

    protected Theme newTheme() {
        return null;
    }

    protected ThemeProvider newThemeProvider() {
        Theme customTheme = this.newTheme();
        if (customTheme != null) {
            return new SingleThemeProvider((ITheme)customTheme);
        }
        return new BootswatchThemeProvider(this.newDefaultTheme());
    }

    private void initBootstrap(ThemeProvider themeProvider) {
        BootstrapSettings settings = new BootstrapSettings();
        settings.setJsResourceFilterName(FOOTER_FILTER_NAME).setThemeProvider(themeProvider);
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        BootstrapLess.install((Application)this);
    }

    protected String newDefaultTheme() {
        return "Cerulean";
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        try {
            properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/config.properties"));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return properties;
    }
}

