/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.toastr;

import de.alpharogroup.wicket.js.addon.core.JavascriptGenerator;
import de.alpharogroup.wicket.js.addon.core.Settings;
import de.alpharogroup.wicket.js.addon.core.StringTextValue;
import de.alpharogroup.wicket.js.addon.toastr.ToastrSettings;
import de.alpharogroup.wicket.js.addon.toastr.ToastrType;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.lang.Args;

public class ToastJsGenerator
extends JavascriptGenerator<ToastrSettings>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COMMAND = "command";

    public ToastJsGenerator() {
        this(ToastrSettings.builder().build());
    }

    public ToastJsGenerator(ToastrSettings settings) {
        this(settings, true);
    }

    public ToastJsGenerator(ToastrSettings settings, boolean withDocumentReadyFunction) {
        super((Settings)Args.notNull((Object)settings, (String)"settings"));
        this.setWithDocumentReadyFunction(withDocumentReadyFunction);
    }

    public String generateJavascriptTemplateContent(Map<String, Object> variables, String methodName) {
        StringBuilder sb = new StringBuilder();
        if (this.isWithDocumentReadyFunction()) {
            sb.append("$(document).ready(function() {").append("\n").append("\n");
        }
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String key = entry.getKey();
            if (COMMAND.equals(key)) continue;
            sb.append(key).append("=${").append(key).append("};");
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("${command};");
        sb.append("\n");
        if (this.isWithDocumentReadyFunction()) {
            sb.append("})");
        }
        return sb.toString();
    }

    public String getCommand(ToastrSettings settings) {
        StringBuilder sb = new StringBuilder();
        sb.append("toastr.");
        sb.append(((ToastrType)((Object)settings.getToastrType().getValue())).getValue());
        sb.append("('");
        sb.append((String)settings.getNotificationContent().getValue());
        sb.append("'");
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)settings.getNotificationTitle().getValue()))) {
            sb.append(", '");
            sb.append((String)settings.getNotificationTitle().getValue());
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    protected Map<String, Object> initializeVariables(Set<StringTextValue<?>> allSettings) {
        Map variables = super.initializeVariables(allSettings);
        variables.put(COMMAND, this.getCommand((ToastrSettings)this.getSettings()));
        return variables;
    }
}

