/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.core;

import de.alpharogroup.wicket.js.addon.core.QuotationMarkType;
import de.alpharogroup.wicket.js.addon.core.StringTextType;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.wicket.util.lang.Args;

public class StringTextValue<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private T value;
    private final T defaultValue;
    private boolean initialValue;
    private QuotationMarkType quotationMarkType = QuotationMarkType.NONE;
    @NonNull
    private final StringTextType type;
    private final String name;

    public StringTextValue(String name, StringTextType stringTextType) {
        this(name, null, stringTextType, true);
    }

    public StringTextValue(String name, T value, StringTextType stringTextType) {
        this(name, value, stringTextType, true);
    }

    public StringTextValue(String name, T value, StringTextType stringTextType, boolean initialValue) {
        Args.notNull((Object)((Object)stringTextType), (String)"type");
        this.value = value;
        this.defaultValue = value;
        this.type = stringTextType;
        this.initialValue = initialValue;
        this.name = name;
        if (stringTextType.equals((Object)StringTextType.BOOLEAN)) {
            this.value = Boolean.FALSE;
        }
        if (stringTextType.equals((Object)StringTextType.STRING) || stringTextType.equals((Object)StringTextType.STRING_INTEGER)) {
            this.setQuotationMarkType(QuotationMarkType.SINGLE);
        }
    }

    public StringTextValue<T> setValue(T value) {
        return this.setValue(value, false);
    }

    public StringTextValue<T> setValue(T value, boolean initialValue) {
        this.initialValue = initialValue;
        this.value = value;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isInitialValue() {
        return this.initialValue;
    }

    public QuotationMarkType getQuotationMarkType() {
        return this.quotationMarkType;
    }

    @NonNull
    public StringTextType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public StringTextValue<T> setQuotationMarkType(QuotationMarkType quotationMarkType) {
        this.quotationMarkType = quotationMarkType;
        return this;
    }
}

