/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.component.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class ComponentExpression {
    private static final String ANY_COMPONENT_MATCHER = "*";
    private static final String ANY_COMPONENT_RECURSIVE_MATCHER = "**";

    private static final boolean evaluateConditions(Collection<Condition> conditions, Component component) {
        boolean result = true;
        for (Condition condition : conditions) {
            switch (condition.getAttr()) {
                case ENABLED: {
                    result = result && component.isEnabledInHierarchy() == condition.getCondition();
                    break;
                }
                case VISIBLE: {
                    boolean bl = result = result && component.isVisibleInHierarchy() == condition.getCondition();
                }
            }
            if (result) continue;
            break;
        }
        return result;
    }

    public static List<Component> findAllComponents(Component parent, String expression) {
        return ComponentExpression.findAllComponents(parent, expression, Component.class);
    }

    public static List<Component> findAllComponents(Component parent, String expression, Class<? extends Component> typeRestriction) {
        if (expression == null || expression.equals("")) {
            return Collections.emptyList();
        }
        return ComponentExpression.findComponent(parent, new LinkedList<String>(Arrays.asList(expression.split(Character.toString(':')))), typeRestriction);
    }

    private static List<Component> findComponent(Component parent, LinkedList<String> expressionListIn, Class<? extends Component> typeRestriction) {
        LinkedList<String> expressionList = new LinkedList<String>(expressionListIn);
        if (expressionList.isEmpty()) {
            if (typeRestriction.isAssignableFrom(parent.getClass())) {
                return Arrays.asList(parent);
            }
            return Collections.emptyList();
        }
        String rawFirst = expressionList.getFirst();
        Collection<Condition> conditions = ComponentExpression.parseConditions(rawFirst);
        String first = rawFirst.replaceAll("\\s*\\[.*\\]\\s*", "");
        if (!first.equals(ANY_COMPONENT_RECURSIVE_MATCHER)) {
            expressionList.removeFirst();
            List<Component> allMatches = ComponentExpression.getChild(parent, first, conditions);
            if (allMatches.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Component> finallyMatchedComponents = new ArrayList<Component>();
            for (Component aMatch : allMatches) {
                finallyMatchedComponents.addAll(ComponentExpression.findComponent(aMatch, expressionList, typeRestriction));
            }
            return finallyMatchedComponents;
        }
        if (expressionList.size() == 1) {
            ArrayList<Component> allMatches = new ArrayList<Component>();
            if (parent instanceof MarkupContainer) {
                for (Component aMatch : ComponentExpression.getAllChildren((MarkupContainer)parent)) {
                    if (typeRestriction.isAssignableFrom(aMatch.getClass()) && ComponentExpression.evaluateConditions(conditions, aMatch)) {
                        allMatches.add(aMatch);
                    }
                    allMatches.addAll(ComponentExpression.findComponent(aMatch, expressionList, typeRestriction));
                }
                return allMatches;
            }
            return Collections.emptyList();
        }
        ArrayList<Component> allMatches = new ArrayList<Component>();
        LinkedList<String> fake = new LinkedList<String>();
        fake.add(ANY_COMPONENT_RECURSIVE_MATCHER);
        List<Component> allPotentialParents = ComponentExpression.findComponent(parent, fake, Component.class);
        expressionList.removeFirst();
        for (Component aParent : allPotentialParents) {
            if (!ComponentExpression.evaluateConditions(conditions, aParent)) continue;
            allMatches.addAll(ComponentExpression.findComponent(aParent, expressionList, typeRestriction));
        }
        return allMatches;
    }

    public static Component findComponent(Component parent, String expression) {
        List<Component> results = ComponentExpression.findAllComponents(parent, expression);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public static Component findComponent(Component parent, String expression, Class<? extends Component> typeRestriction) {
        List<Component> results = ComponentExpression.findAllComponents(parent, expression, typeRestriction);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private static List<Component> getAllChildren(MarkupContainer parent) {
        ArrayList<Component> children = new ArrayList<Component>();
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            children.add((Component)iter.next());
        }
        return children;
    }

    private static List<Component> getChild(Component parent, String expression, Collection<Condition> conditions) {
        if (parent instanceof MarkupContainer) {
            MarkupContainer parentContainer = (MarkupContainer)parent;
            if (expression.equals(ANY_COMPONENT_MATCHER)) {
                List<Component> allChildren = ComponentExpression.getAllChildren(parentContainer);
                ArrayList<Component> allChildrenMatchingCondition = new ArrayList<Component>();
                for (Component child : allChildren) {
                    if (child == null || !ComponentExpression.evaluateConditions(conditions, child)) continue;
                    allChildrenMatchingCondition.add(child);
                }
                return allChildrenMatchingCondition;
            }
            Component comp = parentContainer.get(expression);
            if (comp == null || !ComponentExpression.evaluateConditions(conditions, comp)) {
                return Collections.emptyList();
            }
            return Arrays.asList(comp);
        }
        return Collections.emptyList();
    }

    private static final Collection<Condition> parseConditions(String expression) {
        ArrayList<Condition> parsedConditions = new ArrayList<Condition>();
        Pattern pattern = Pattern.compile(".*\\[\\s*(.*?)\\s*\\]\\w*", 2);
        Matcher matcher = pattern.matcher(expression);
        if (matcher.matches()) {
            String[] conditions;
            String conditionString = matcher.group(1);
            for (String aCondition : conditions = conditionString.split("\\s*(and|&)\\s*")) {
                Condition.Attr attr = null;
                Boolean condition = null;
                String[] parts = null;
                if (!aCondition.contains("=") || (parts = aCondition.split("\\s*=\\s*")).length != 2) continue;
                if (parts[0].toUpperCase().equals(Condition.Attr.VISIBLE.toString())) {
                    attr = Condition.Attr.VISIBLE;
                } else if (parts[0].toUpperCase().equals(Condition.Attr.ENABLED.toString())) {
                    attr = Condition.Attr.ENABLED;
                }
                if (parts[1].toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
                    condition = Boolean.TRUE;
                } else if (parts[1].toUpperCase().equals(Boolean.FALSE.toString().toUpperCase())) {
                    condition = Boolean.FALSE;
                }
                if (attr == null || condition == null) continue;
                parsedConditions.add(new Condition(attr, condition));
            }
        }
        return parsedConditions;
    }

    private static final class Condition {
        private final Attr attr;
        private final boolean condition;

        public Condition(Attr attr, boolean condition) {
            this.attr = attr;
            this.condition = condition;
        }

        public Attr getAttr() {
            return this.attr;
        }

        public boolean getCondition() {
            return this.condition;
        }

        public String toString() {
            return String.format("Condition [attr=%s, condition=%s]", new Object[]{this.attr, this.condition});
        }

        private static enum Attr {
            VISIBLE,
            ENABLED;

        }
    }
}

