/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.date;

import de.alpharogroup.date.DatePatterns;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public final class DateExtensions
implements DatePatterns {
    public static Map<String, Object> getAllDatePatterns() throws IllegalAccessException {
        Field[] fields = DatePatterns.class.getFields();
        HashMap<String, Object> patterns = new HashMap<String, Object>(fields.length);
        for (Field field : fields) {
            patterns.put(field.getName(), field.get(field.getName()));
        }
        return patterns;
    }

    public static List<String> getDatePatterns() throws IllegalAccessException {
        Field[] fields = DatePatterns.class.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add((String)field.get(field.getName()));
        }
        return list;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHours(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinutes(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getSeconds(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date setDate(Date dateToSet, int year, int month, int day, int hour, int minute, int second, int milliSecond, TimeZone zone, Locale locale) {
        Objects.requireNonNull(dateToSet);
        Calendar calendar = Calendar.getInstance(zone, locale);
        calendar.setTime(dateToSet);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
        return calendar.getTime();
    }

    public static Date setDate(Date dateToSet, int hour, int minute, int second, int milliSecond, TimeZone zone, Locale locale) {
        Objects.requireNonNull(dateToSet);
        return DateExtensions.setDate(dateToSet, DateExtensions.getYear(dateToSet), DateExtensions.getMonth(dateToSet), DateExtensions.getDay(dateToSet), hour, minute, second, milliSecond, zone, locale);
    }

    private DateExtensions() {
    }
}

