/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.date;

import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.date.DateExtensions;
import de.alpharogroup.date.DatePatterns;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class CreateDateExtensions
implements DatePatterns {
    public static Date inPast(Date from, int millis) {
        return CalculateDateExtensions.addMilliseconds(from, millis * -1);
    }

    public static Date newDate(int year, int month, int day) {
        return CreateDateExtensions.newDate(year, month, day, 0, 0, 0);
    }

    public static Date newDate(int year, int month, int day, int hour, int min, int sec) {
        return CreateDateExtensions.newDate(year, month, day, hour, min, sec, 0);
    }

    public static Date newDate(int year, int month, int day, int hour, int minute, int seconds, int milliSecond) {
        return CreateDateExtensions.newDate(year, month, day, hour, minute, seconds, milliSecond, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Date newDate(int year, int month, int day, int hour, int minute, int seconds, int milliSecond, TimeZone zone, Locale locale) {
        return DateExtensions.setDate(new Date(), year, month, day, hour, minute, seconds, milliSecond, zone, locale);
    }

    public static Date newDate(long time) {
        return new Date(time);
    }

    public static Date newRandomDate(Date from) {
        SecureRandom secrand = new SecureRandom();
        double randDouble = -secrand.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secrand.nextDouble();
        double result = randDouble * randomDouble;
        return new Date((long)result);
    }

    public static Date now() {
        return CreateDateExtensions.newDate(System.currentTimeMillis());
    }

    private CreateDateExtensions() {
    }
}

