/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.velocity;

import de.alpharogroup.file.create.FileFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public final class VelocityExtensions {
    public static final String CLASSPATH_VALUE = "classpath";
    public static final String KEY_CLASSPATH_RESOURCE_LOADER_CLASS = "classpath.resource.loader.class";
    public static final String VELOCITY_TEMPLATE_FILE_EXTENSION = ".vm";

    public static VelocityEngine getClasspathResourceLoaderVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)CLASSPATH_VALUE);
        ve.setProperty(KEY_CLASSPATH_RESOURCE_LOADER_CLASS, (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    public static Template getTemplate(String templateAsString) throws ParseException {
        return VelocityExtensions.getTemplate(templateAsString, "Template name", "UTF-8");
    }

    public static Template getTemplate(String templateAsString, String templateName) throws ParseException {
        return VelocityExtensions.getTemplate(templateAsString, templateName, "UTF-8");
    }

    public static Template getTemplate(String templateAsString, String templateName, String encoding) throws ParseException {
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        StringReader reader = new StringReader(templateAsString);
        SimpleNode node = runtimeServices.parse((Reader)reader, templateName);
        Template template = new Template();
        template.setName(templateName);
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)node);
        template.initDocument();
        template.setEncoding(encoding);
        return template;
    }

    public static Template getTemplate(VelocityEngine ve, String path, String templateName) {
        return VelocityExtensions.getTemplate(ve, path, templateName, "UTF-8");
    }

    public static Template getTemplate(VelocityEngine ve, String path, String templateName, String encoding) {
        String templatePath = path + templateName + VELOCITY_TEMPLATE_FILE_EXTENSION;
        return VelocityExtensions.getVelocityTemplate(ve, templatePath, encoding);
    }

    private static Template getVelocityTemplate(VelocityEngine ve, String templatePath) {
        return VelocityExtensions.getVelocityTemplate(ve, templatePath, "UTF-8");
    }

    private static Template getVelocityTemplate(VelocityEngine ve, String templatePath, String encoding) {
        Template template = ve != null ? ve.getTemplate(templatePath, encoding) : Velocity.getTemplate((String)templatePath, (String)encoding);
        return template;
    }

    public static String merge(VelocityContext context, Properties velocityProperties, String logTag, String templateAsString) {
        StringWriter writer = new StringWriter();
        if (velocityProperties != null && !velocityProperties.isEmpty()) {
            Velocity.init((Properties)velocityProperties);
        }
        Velocity.evaluate((Context)context, (Writer)writer, (String)logTag, (String)templateAsString);
        return writer.toString();
    }

    public static String merge(VelocityContext context, String templateAsString) {
        return VelocityExtensions.merge(context, "VelocityUtilsMergeMethod", templateAsString);
    }

    public static String merge(VelocityContext context, String logTag, String templateAsString) {
        return VelocityExtensions.merge(context, null, logTag, templateAsString);
    }

    public static void mergeToContext(VelocityEngine ve, VelocityContext context, String templateFileName, String fileName) throws IOException {
        File generatedClassFile = new File(fileName);
        FileFactory.newFile((File)generatedClassFile);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));
        Template template = VelocityExtensions.getVelocityTemplate(ve, templateFileName);
        template.merge((Context)context, (Writer)bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static void mergeToContext(VelocityEngine ve, VelocityContext context, String path, String templateName, String fileName, String encoding) throws IOException {
        File generatedClassFile = new File(fileName);
        FileFactory.newFile((File)generatedClassFile);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));
        Template template = VelocityExtensions.getTemplate(ve, path, templateName, encoding);
        template.merge((Context)context, (Writer)bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static VelocityContext newVelocityContext() {
        VelocityContext context = new VelocityContext();
        return context;
    }

    private VelocityExtensions() {
    }
}

