/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.rest;

import de.alpharogroup.auth.Credentials;
import de.alpharogroup.auth.models.AuthenticationResult;
import de.alpharogroup.auth.token.AuthToken;
import de.alpharogroup.user.rest.api.BaseAuthenticationsResource;
import de.alpharogroup.user.service.api.BaseAuthenticationService;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;

public class BaseAuthenticationsRestResource
implements BaseAuthenticationsResource {
    private BaseAuthenticationService baseAuthenticationService;

    @Override
    public Response authenticate(Credentials credentials) {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        return this.authenticate(username, password);
    }

    @Override
    public Response authenticate(String username, String password) {
        AuthenticationResult result = this.baseAuthenticationService.authenticate(username, password);
        if (CollectionUtils.isNotEmpty((Collection)result.getValidationErrors())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Access-Control-Allow-Origin", (Object)"*").build();
        }
        String authenticationToken = this.baseAuthenticationService.newAuthenticationToken(username);
        AuthToken authToken = AuthToken.builder().value(authenticationToken).build();
        return Response.ok((Object)authToken.getValue()).header("Access-Control-Allow-Origin", (Object)"*").build();
    }

    public BaseAuthenticationService getBaseAuthenticationService() {
        return this.baseAuthenticationService;
    }

    public void setBaseAuthenticationService(BaseAuthenticationService baseAuthenticationService) {
        this.baseAuthenticationService = baseAuthenticationService;
    }
}

