/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.filter;

import de.alpharogroup.service.rs.filter.AuthenticationFilter;
import de.alpharogroup.user.service.api.UserTokenService;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class UserAuthenticationFilter
extends AuthenticationFilter {
    private static final int DEFAULT_MAX_ENTRIES = 1000;
    private final Map<String, LocalDateTime> validTokens = this.newValidTokenCache();
    @Autowired
    private UserTokenService userTokenService;

    protected String onValidateToken(String token) throws Exception {
        if (!this.validTokens.containsKey(token) && !this.userTokenService.isValid(token)) {
            throw new Exception("UnauthorizedException with Token:" + token);
        }
        this.validTokens.put(token, LocalDateTime.now());
        return token;
    }

    protected Map<String, LocalDateTime> newValidTokenCache() {
        LinkedHashMap<String, LocalDateTime> validTokens = new LinkedHashMap<String, LocalDateTime>(1001, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<String, LocalDateTime> eldest) {
                return this.size() > 1000;
            }
        };
        return validTokens;
    }

    public UserTokenService getUserTokenService() {
        return this.userTokenService;
    }

    public void setUserTokenService(UserTokenService userTokenService) {
        this.userTokenService = userTokenService;
    }
}

