/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.filter;

import com.google.common.collect.MapMaker;
import de.alpharogroup.service.rs.filter.AuthenticationFilter;
import de.alpharogroup.user.service.api.UserTokenService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class UserAuthenticationFilter
extends AuthenticationFilter {
    private final Map<String, LocalDateTime> validTokens = new MapMaker().expiration(30L, TimeUnit.MINUTES).makeMap();
    @Autowired
    private UserTokenService userTokenService;

    protected String onValidateToken(String token) throws Exception {
        if (!this.validTokens.containsKey(token) && !this.userTokenService.isValid(token)) {
            throw new Exception("UnauthorizedException with Token:" + token);
        }
        this.validTokens.put(token, LocalDateTime.now());
        return token;
    }

    public UserTokenService getUserTokenService() {
        return this.userTokenService;
    }

    public void setUserTokenService(UserTokenService userTokenService) {
        this.userTokenService = userTokenService;
    }
}

