/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.rest.api;

import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.collections.pairs.Triple;
import de.alpharogroup.service.rs.RestfulResource;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.management.domain.model.UserSearchCriteria;
import de.alpharogroup.user.management.enums.GenderType;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/user/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface UsersResource
extends RestfulResource<Integer, User> {
    @GET
    @Path(value="/exists/user/with/username/{username}")
    public boolean existsUserWithUsername(@PathParam(value="username") String var1);

    @POST
    @Path(value="/find/addresses")
    public List<Address> findAddressesFromUser(User var1);

    @POST
    @Path(value="/find/address")
    public Address findAddressFromUser(User var1);

    @GET
    @Path(value="/findall/")
    public List<User> findAll();

    @POST
    @Path(value="/find/roles")
    public List<Role> findRolesFromUser(User var1);

    @POST
    @Path(value="/find/users")
    public List<User> findUsers(Triple<Integer, GenderType, Integer> var1);

    @POST
    @Path(value="/find/users/by/geo")
    public List<User> findUsers(UserSearchCriteria var1);

    @GET
    @Path(value="/find/by/email/{email}")
    public User findUserWithEmail(@PathParam(value="email") String var1);

    @GET
    @Path(value="/find/by/username/{username}")
    public User findUserWithUsername(String var1);

    @POST
    @Path(value="/user/is/in/role")
    public boolean userIsInRole(KeyValuePair<User, Role> var1);
}

