/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.rest.api;

import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.auth.enums.InsertUserState;
import de.alpharogroup.auth.exceptions.EmailAlreadyExistsException;
import de.alpharogroup.auth.exceptions.UserAlreadyExistsException;
import de.alpharogroup.auth.models.UsernameSignUpModel;
import de.alpharogroup.auth.models.ValidationErrors;
import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.collections.pairs.Triple;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.domain.Resource;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.management.domain.Contactmethod;
import de.alpharogroup.user.management.domain.UserData;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.sign.up.SignUpUserResult;
import de.alpharogroup.user.management.sign.up.UserModel;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/usermanagement/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface UserManagementResource {
    @POST
    @Path(value="/add/user/contact")
    public User addUserContact(KeyValuePair<User, User> var1);

    @POST
    @Path(value="/delete/address")
    public UserData deleteAddress(KeyValuePair<Address, UserData> var1);

    @POST
    @Path(value="/delete/blacklisted")
    public UserData deleteBlacklisted(KeyValuePair<User, Integer> var1);

    @POST
    @Path(value="/delete/resource")
    public void deleteResource(KeyValuePair<ResourcesModel, Integer> var1);

    @POST
    @Path(value="/exists/user/by/email")
    public boolean existsUserWithEmail(Contactmethod var1);

    @GET
    @Path(value="/exists/user/with/email/{email}")
    public boolean existsUserWithEmail(@PathParam(value="email") String var1);

    @POST
    @Path(value="/exists/user/with/email/or/username")
    public InsertUserState existsUserWithEmailOrUsername(KeyValuePair<String, String> var1);

    @GET
    @Path(value="/exists/user/with/emailOrUsername/{emailOrUsername}")
    public boolean existsUserWithEmailOrUsername(@PathParam(value="emailOrUsername") String var1);

    @GET
    @Path(value="/exists/user/with/username/{username}")
    public boolean existsUserWithUsername(@PathParam(value="username") String var1);

    @POST
    @Path(value="/find/addresses")
    public List<Address> findAddessesFromUser(User var1);

    @POST
    @Path(value="/find/address")
    public Address findAddressFromUser(User var1);

    @POST
    @Path(value="/find/all/emails")
    public List<Contactmethod> findAllEmailContactmethodsFromUser(User var1);

    @POST
    @Path(value="/find/all/faxes")
    public List<Contactmethod> findAllFaxContactmethodsFromUser(User var1);

    @POST
    @Path(value="/find/all/internets")
    public List<Contactmethod> findAllInternetContactmethodsFromUser(User var1);

    @POST
    @Path(value="/find/all/mobiles")
    public List<Contactmethod> findAllMobileContactmethodsFromUser(User var1);

    @POST
    @Path(value="/find/all/tel")
    public List<Contactmethod> findAllTelefonContactmethodsFromUser(User var1);

    @POST
    @Path(value="/find/email")
    public Contactmethod findEmailContactFromUser(User var1);

    @POST
    @Path(value="/find/fax")
    public Contactmethod findFaxContactFromUser(User var1);

    @POST
    @Path(value="/find/internet")
    public Contactmethod findInternetContactFromUser(User var1);

    @POST
    @Path(value="/find/mobile")
    public Contactmethod findMobileContactFromUser(User var1);

    @POST
    @Path(value="/find/roles")
    public List<Role> findRolesFromUser(User var1);

    @POST
    @Path(value="/find/tel")
    public Contactmethod findTelefonContactFromUser(User var1);

    @GET
    @Path(value="/find/by/email/{email}")
    public User findUserWithEmail(@PathParam(value="email") String var1);

    @GET
    @Path(value="/find/by/email/or/username/{emailOrUsername}")
    public User findUserWithEmailOrUsername(@PathParam(value="emailOrUsername") String var1);

    @GET
    @Path(value="/find/by/username/{username}")
    public User findUserWithUsername(@PathParam(value="username") String var1);

    @POST
    @Path(value="/isin/role")
    public boolean isInRole(KeyValuePair<String, List<Role>> var1);

    @POST
    @Path(value="/is/user/in/role")
    public boolean isUserInRole(KeyValuePair<User, String> var1);

    @POST
    @Path(value="/persist/resource")
    public Resource persistResource(KeyValuePair<ResourcesModel, Integer> var1);

    @POST
    @Path(value="/save/addresses")
    public void saveAddressesFromUser(KeyValuePair<User, Collection<Address>> var1);

    @POST
    @Path(value="/save/address")
    public void saveAddressFromUser(KeyValuePair<User, Address> var1);

    @POST
    @Path(value="/new/user")
    public Serializable saveNewUser(User var1) throws UserAlreadyExistsException;

    @POST
    @Path(value="/new/user/onlywith/email")
    public Serializable saveUserOnlyWithEmail(User var1) throws UserAlreadyExistsException;

    @POST
    @Path(value="/save/user/with/contactmethod")
    public Contactmethod saveUserWithContactmethod(KeyValuePair<User, Contactmethod> var1) throws BatchUpdateException;

    @POST
    @Path(value="/save/user/with/contactmethods")
    public List<Contactmethod> saveUserWithContactmethods(KeyValuePair<User, List<Contactmethod>> var1) throws BatchUpdateException;

    @POST
    @Path(value="/save/user/with/roles")
    public void saveUserWithRoles(KeyValuePair<User, Collection<Role>> var1);

    @POST
    @Path(value="/set/email")
    public Contactmethod setEmail(KeyValuePair<String, User> var1) throws EmailAlreadyExistsException;

    @POST
    @Path(value="/set/username")
    public boolean setUsername(KeyValuePair<String, User> var1) throws UserAlreadyExistsException;

    @POST
    @Path(value="/signup/user")
    public SignUpUserResult signUpUser(Triple<UsernameSignUpModel, Set<Role>, UserModel> var1);

    @POST
    @Path(value="/update/contactmethod")
    public Contactmethod updateContactmethod(Triple<String, ContactmethodType, Contactmethod> var1);

    @POST
    @Path(value="/update/username")
    public boolean updateUsername(KeyValuePair<String, User> var1) throws UserAlreadyExistsException;

    @POST
    @Path(value="/user/is/in/role")
    public boolean userIsInRole(KeyValuePair<User, Role> var1);

    @POST
    @Path(value="/validate")
    public ValidationErrors validate(UsernameSignUpModel var1);
}

