/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.rest;

import de.alpharogroup.auth.Credentials;
import de.alpharogroup.auth.models.AuthenticationResult;
import de.alpharogroup.auth.token.AuthToken;
import de.alpharogroup.user.management.rest.api.AuthenticationsResource;
import de.alpharogroup.user.management.service.api.AuthenticationService;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;

public class AuthenticationsRestResource
implements AuthenticationsResource {
    private AuthenticationService authenticationService;

    @Override
    public Response authenticate(Credentials credentials) {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        return this.authenticate(username, password);
    }

    @Override
    public Response authenticate(String username, String password) {
        AuthenticationResult result = this.authenticationService.authenticate(username, password);
        if (CollectionUtils.isNotEmpty((Collection)result.getValidationErrors())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Access-Control-Allow-Origin", (Object)"*").build();
        }
        String authenticationToken = this.authenticationService.newAuthenticationToken(username);
        AuthToken authToken = AuthToken.builder().value(authenticationToken).build();
        return Response.ok((Object)authToken.getValue()).header("Access-Control-Allow-Origin", (Object)"*").build();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

