/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.filter;

import com.google.common.collect.MapMaker;
import de.alpharogroup.service.rs.filter.AuthenticationFilter;
import de.alpharogroup.user.management.service.api.UserManagementService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class UserAuthenticationFilter
extends AuthenticationFilter {
    private Map<String, LocalDateTime> validTokens = new MapMaker().expiration(30L, TimeUnit.MINUTES).makeMap();
    @Autowired
    private UserManagementService userManagementService;

    protected String onValidateToken(String token) throws Exception {
        if (!this.validTokens.containsKey(token) && !this.userManagementService.isValid(token)) {
            throw new Exception("UnauthorizedException with Token:" + token);
        }
        this.validTokens.put(token, LocalDateTime.now());
        return token;
    }

    public UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }
}

