/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.factories;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.entities.RelationPermissions;
import de.alpharogroup.user.entities.ResetPasswords;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.entities.Recommendations;
import de.alpharogroup.user.management.entities.Robinsons;
import de.alpharogroup.user.management.entities.RuleViolations;
import de.alpharogroup.user.management.entities.UserDatas;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.enums.GenderType;
import de.alpharogroup.user.management.enums.RuleViolationReason;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class UserManagementFactory
implements Serializable {
    private static final UserManagementFactory instance = new UserManagementFactory();
    private static final long serialVersionUID = 1L;

    public static UserManagementFactory getInstance() {
        return instance;
    }

    private UserManagementFactory() {
    }

    public Contactmethods newContactmethods(ContactmethodType contactmethod, String contactvalue) {
        return this.newContactmethods(contactmethod, contactvalue, null);
    }

    public Contactmethods newContactmethods(ContactmethodType contactmethod, String contactvalue, Integer id) {
        Contactmethods contactmethods = new Contactmethods();
        contactmethods.setContactmethod(contactmethod);
        contactmethods.setContactvalue(contactvalue);
        contactmethods.setId(id);
        return contactmethods;
    }

    public Permissions newPermissions(Integer id, String permission, String description, String shortcut) {
        Permissions permissions = new Permissions();
        permissions.setDescription(description);
        permissions.setId((Serializable)id);
        permissions.setPermissionName(permission);
        permissions.setShortcut(shortcut);
        return permissions;
    }

    public Permissions newPermissions(String permission, String description) {
        return this.newPermissions(null, permission, description, null);
    }

    public Permissions newPermissions(String permission, String description, String shortcut) {
        return this.newPermissions(null, permission, description, shortcut);
    }

    public Recommendations newRecommendations(Integer id, Users user, Users recommended, String email, String invitationText, Boolean sent) {
        Recommendations recommendation = new Recommendations();
        recommendation.setId(id);
        recommendation.setUser(user);
        recommendation.setRecommended(recommended);
        recommendation.setEmail(email);
        recommendation.setInvitationText(invitationText);
        recommendation.setSent(sent);
        return recommendation;
    }

    public Recommendations newRecommendations(Users user, Users recommended, String email, String invitationText) {
        return this.newRecommendations(user, recommended, email, invitationText, Boolean.FALSE);
    }

    public Recommendations newRecommendations(Users user, Users recommended, String email, String invitationText, Boolean sent) {
        return this.newRecommendations(null, user, recommended, email, invitationText, sent);
    }

    public RelationPermissions newRelationPermissions(Integer id, Users provider, Users subscriber, Set<Permissions> permissions) {
        RelationPermissions relationPermissions = new RelationPermissions();
        relationPermissions.setId((Serializable)id);
        relationPermissions.setProvider(provider);
        relationPermissions.setSubscriber(subscriber);
        relationPermissions.setPermissions(permissions);
        return relationPermissions;
    }

    public RelationPermissions newRelationPermissions(Users provider, Users subscriber) {
        return this.newRelationPermissions(provider, subscriber, new HashSet<Permissions>());
    }

    public RelationPermissions newRelationPermissions(Users provider, Users subscriber, Set<Permissions> permissions) {
        return this.newRelationPermissions(null, provider, subscriber, permissions);
    }

    public ResetPasswords newResetPasswords(Date expiryDate, String generatedPassword, Date starttime, Users user) {
        return this.newResetPasswords(null, expiryDate, generatedPassword, starttime, user);
    }

    public ResetPasswords newResetPasswords(Integer id, Date expiryDate, String generatedPassword, Date starttime, Users user) {
        ResetPasswords resetPasswords = new ResetPasswords();
        resetPasswords.setExpiryDate(expiryDate);
        resetPasswords.setGeneratedPassword(generatedPassword);
        resetPasswords.setId((Serializable)id);
        resetPasswords.setStarttime(starttime);
        resetPasswords.setUser(user);
        return resetPasswords;
    }

    public Robinsons newRobinsons(Integer id, Users robinson) {
        Robinsons robinsons = new Robinsons();
        robinsons.setId(id);
        robinsons.setRobinson(robinson);
        return robinsons;
    }

    public Robinsons newRobinsons(Users robinson) {
        return this.newRobinsons(null, robinson);
    }

    public Roles newRoles(Integer id, String rolename, String description, Set<Permissions> permissions) {
        Roles roles = new Roles();
        roles.setDescription(description);
        roles.setId((Serializable)id);
        roles.setRolename(rolename);
        if (permissions != null) {
            roles.setPermissions(permissions);
        }
        return roles;
    }

    public Roles newRoles(String rolename, String description) {
        return this.newRoles(rolename, description, null);
    }

    public Roles newRoles(String rolename, String description, Set<Permissions> permissions) {
        return this.newRoles(null, rolename, description, permissions);
    }

    public RuleViolations newRuleViolations(Integer id, Users detector, Users violator, String description, RuleViolationReason reason) {
        RuleViolations ruleViolations = new RuleViolations();
        ruleViolations.setId(id);
        ruleViolations.setDetector(detector);
        ruleViolations.setViolator(violator);
        ruleViolations.setDescription(description);
        ruleViolations.setReason(reason);
        return ruleViolations;
    }

    public RuleViolations newRuleViolations(Users detector, Users violator, String description, RuleViolationReason reason) {
        return this.newRuleViolations(null, detector, violator, description, reason);
    }

    public UserDatas newUserData(Integer id, String birthname, Date dateofbirth, String firstname, GenderType gender, String ipAddress, String lastname, String locale) {
        return this.newUserData(id, birthname, dateofbirth, firstname, gender, ipAddress, lastname, locale, null, null, null, null);
    }

    public UserDatas newUserData(Integer id, String birthname, Date dateofbirth, String firstname, GenderType gender, String ipAddress, String lastname, String locale, Set<Addresses> addresses, Set<Contactmethods> contactmethods, Set<Resources> resources, Set<Users> userContacts) {
        return this.newUserData(id, null, birthname, dateofbirth, firstname, gender, ipAddress, lastname, locale, null, null, null, null);
    }

    public UserDatas newUserData(Integer id, Users owner, String birthname, Date dateofbirth, String firstname, GenderType gender, String ipAddress, String lastname, String locale, Set<Addresses> addresses, Set<Contactmethods> contactmethods, Set<Resources> resources, Set<Users> userContacts) {
        UserDatas userData = new UserDatas();
        userData.setOwner(owner);
        userData.setBirthname(birthname);
        userData.setContactmethods(contactmethods);
        userData.setDateofbirth(dateofbirth);
        userData.setFirstname(firstname);
        userData.setGender(gender);
        userData.setId(id);
        userData.setIpAddress(ipAddress);
        userData.setLastname(lastname);
        userData.setLocale(locale);
        if (addresses != null) {
            userData.setAddresses(addresses);
        }
        if (contactmethods != null) {
            userData.setContactmethods(contactmethods);
        }
        if (resources != null) {
            userData.setResources(resources);
        }
        if (userContacts != null) {
            userData.setUserContacts(userContacts);
        }
        return userData;
    }

    public UserDatas newUserData(String birthname, Date dateofbirth, String firstname, GenderType gender, String ipAddress, String lastname, String locale) {
        return this.newUserData(null, birthname, dateofbirth, firstname, gender, ipAddress, lastname, locale);
    }

    public Users newUsers(Boolean active, String pw, String salt, String username, Boolean locked, Set<Roles> roles) {
        return this.newUsers(null, active, pw, salt, username, locked, roles);
    }

    public Users newUsers(Integer id, Boolean active, String pw, String salt, String username, Boolean locked, Set<Roles> roles) {
        Users users = new Users();
        users.setActive(active);
        users.setLocked(locked);
        users.setId((Serializable)id);
        users.setPw(pw);
        users.setSalt(salt);
        users.setUsername(username);
        if (roles != null) {
            users.setRoles(roles);
        }
        return users;
    }
}

