/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.entities;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.postgres.usertype.PGEnumUserType;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.enums.GenderType;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

@Entity
@Table(name="user_data")
@TypeDefs(value={@TypeDef(name="genderConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="de.alpharogroup.user.management.enums.GenderType")})})
public class UserDatas
extends BaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="owner")
    private Users owner;
    @ManyToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    @JoinTable(name="user_addresses", joinColumns={@JoinColumn(name="user_data_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="addresses_id", referencedColumnName="id")})
    private Set<Addresses> addresses = new HashSet<Addresses>();
    @Column(name="birthname", length=64)
    private String birthname;
    @ManyToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    @JoinTable(name="blacklisted_contacts", joinColumns={@JoinColumn(name="user_data_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="blacklisted_id", referencedColumnName="id")})
    private Set<Users> blacklistedContacts = new HashSet<Users>();
    @ManyToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    @JoinTable(name="user_contactmethods", joinColumns={@JoinColumn(name="user_data_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="contactmethods_id", referencedColumnName="id")})
    private Set<Contactmethods> contactmethods = new HashSet<Contactmethods>();
    private Date dateofbirth;
    @Column(name="firstname", length=64)
    private String firstname;
    @Enumerated(value=EnumType.STRING)
    @Column(name="gender")
    @Type(type="genderConverter")
    private GenderType gender;
    @ManyToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE})
    @JoinTable(name="user_resources", joinColumns={@JoinColumn(name="user_data_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="resources_id", referencedColumnName="id")})
    private Set<Resources> resources = new HashSet<Resources>();
    @Column(name="ip_address", length=16)
    private String ipAddress;
    @Column(name="lastname", length=64)
    private String lastname;
    @Column(name="locale", length=12)
    private String locale;
    @ManyToOne
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="primary_address_id", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_USER_DATA_PRIMARY_ADDRESS_ID"))
    private Addresses primaryAddress;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_contacts", joinColumns={@JoinColumn(name="user_data_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="user_contact_id", referencedColumnName="id")})
    private Set<Users> userContacts = new HashSet<Users>();

    public Users getOwner() {
        return this.owner;
    }

    public Set<Addresses> getAddresses() {
        return this.addresses;
    }

    public String getBirthname() {
        return this.birthname;
    }

    public Set<Users> getBlacklistedContacts() {
        return this.blacklistedContacts;
    }

    public Set<Contactmethods> getContactmethods() {
        return this.contactmethods;
    }

    public Date getDateofbirth() {
        return this.dateofbirth;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public GenderType getGender() {
        return this.gender;
    }

    public Set<Resources> getResources() {
        return this.resources;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getLocale() {
        return this.locale;
    }

    public Addresses getPrimaryAddress() {
        return this.primaryAddress;
    }

    public Set<Users> getUserContacts() {
        return this.userContacts;
    }

    public void setOwner(Users owner) {
        this.owner = owner;
    }

    public void setAddresses(Set<Addresses> addresses) {
        this.addresses = addresses;
    }

    public void setBirthname(String birthname) {
        this.birthname = birthname;
    }

    public void setBlacklistedContacts(Set<Users> blacklistedContacts) {
        this.blacklistedContacts = blacklistedContacts;
    }

    public void setContactmethods(Set<Contactmethods> contactmethods) {
        this.contactmethods = contactmethods;
    }

    public void setDateofbirth(Date dateofbirth) {
        this.dateofbirth = dateofbirth;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setGender(GenderType gender) {
        this.gender = gender;
    }

    public void setResources(Set<Resources> resources) {
        this.resources = resources;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setPrimaryAddress(Addresses primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public void setUserContacts(Set<Users> userContacts) {
        this.userContacts = userContacts;
    }
}

