/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service.api;

import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.auth.exceptions.EmailAlreadyExistsException;
import de.alpharogroup.auth.exceptions.UserAlreadyExistsException;
import de.alpharogroup.auth.models.UsernameSignUpModel;
import de.alpharogroup.auth.models.ValidationErrors;
import de.alpharogroup.auth.usermanagement.UserExistenceService;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.domain.Resource;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.management.domain.Contactmethod;
import de.alpharogroup.user.management.domain.UserData;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.sign.up.SignUpUserResult;
import de.alpharogroup.user.management.sign.up.UserModel;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface UserManagementService
extends UserExistenceService {
    public User addUserContact(User var1, User var2);

    public UserData deleteAddress(Address var1, UserData var2);

    public UserData deleteBlacklisted(User var1, Integer var2);

    public void deleteResource(ResourcesModel var1, Integer var2);

    public boolean existsUserWithEmail(Contactmethod var1);

    public boolean existsUserWithEmailOrUsername(String var1);

    public List<Address> findAddessesFromUser(User var1);

    public Address findAddressFromUser(User var1);

    public List<Contactmethod> findAllEmailContactmethodsFromUser(User var1);

    public List<Contactmethod> findAllFaxContactmethodsFromUser(User var1);

    public List<Contactmethod> findAllInternetContactmethodsFromUser(User var1);

    public List<Contactmethod> findAllMobileContactmethodsFromUser(User var1);

    public List<Contactmethod> findAllTelefonContactmethodsFromUser(User var1);

    public Contactmethod findEmailContactFromUser(User var1);

    public Contactmethod findFaxContactFromUser(User var1);

    public Contactmethod findInternetContactFromUser(User var1);

    public Contactmethod findMobileContactFromUser(User var1);

    public List<Role> findRolesFromUser(User var1);

    public Contactmethod findTelefonContactFromUser(User var1);

    public User findUserWithEmail(String var1);

    public User findUserWithEmailOrUsername(String var1);

    public User findUserWithUsername(String var1);

    public boolean isInRole(String var1, List<Role> var2);

    public boolean isUserInRole(User var1, String var2);

    public boolean isValid(String var1);

    public String newAuthenticationToken(String var1);

    public Resource persistResource(ResourcesModel var1, Integer var2);

    public void saveAddressesFromUser(User var1, Collection<Address> var2);

    public void saveAddressFromUser(User var1, Address var2);

    public Serializable saveNewUser(User var1) throws UserAlreadyExistsException;

    public Serializable saveUserOnlyWithEmail(User var1) throws UserAlreadyExistsException;

    public Contactmethod saveUserWithContactmethod(User var1, Contactmethod var2) throws BatchUpdateException;

    public List<Contactmethod> saveUserWithContactmethods(User var1, List<Contactmethod> var2) throws BatchUpdateException;

    public void saveUserWithRoles(User var1, Collection<Role> var2);

    public Contactmethod setEmail(String var1, User var2) throws EmailAlreadyExistsException;

    public boolean setUsername(String var1, User var2) throws UserAlreadyExistsException;

    public SignUpUserResult signUpUser(UsernameSignUpModel var1, Set<Role> var2, UserModel var3);

    public Contactmethod updateContactmethod(String var1, ContactmethodType var2, Contactmethod var3);

    public boolean updateUsername(String var1, User var2) throws UserAlreadyExistsException;

    public boolean userIsInRole(User var1, Role var2);

    public ValidationErrors validate(UsernameSignUpModel var1);
}

