/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.auth.enums.InsertUserState;
import de.alpharogroup.auth.exceptions.EmailAlreadyExistsException;
import de.alpharogroup.auth.exceptions.UserAlreadyExistsException;
import de.alpharogroup.auth.models.UsernameSignUpModel;
import de.alpharogroup.auth.models.ValidationErrors;
import de.alpharogroup.db.entitymapper.MapperExtensions;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.domain.Resource;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.domain.Contactmethod;
import de.alpharogroup.user.management.domain.UserData;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.entities.UserDatas;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.service.api.UserManagementService;
import de.alpharogroup.user.management.service.api.UsersManagementService;
import de.alpharogroup.user.management.sign.up.SignUpUserResult;
import de.alpharogroup.user.management.sign.up.UserModel;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="userManagementDomainService")
public class UserManagementDomainService
implements UserManagementService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsersManagementService usersManagementService;
    private Mapper mapper;

    @Override
    public User addUserContact(User user, User contact) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Users contacts = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)contact, Users.class);
        users = this.usersManagementService.addUserContact(users, contacts);
        User userDomainObject = (User)MapperExtensions.map((Mapper)this.getMapper(), (Object)users, User.class);
        return userDomainObject;
    }

    @Override
    public UserData deleteAddress(Address address, UserData ud) {
        Addresses addresses = (Addresses)MapperExtensions.map((Mapper)this.getMapper(), (Object)address, Addresses.class);
        UserDatas userDatas = (UserDatas)MapperExtensions.map((Mapper)this.getMapper(), (Object)((Object)ud), UserDatas.class);
        userDatas = this.usersManagementService.deleteAddress(addresses, userDatas);
        UserData userData = (UserData)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)userDatas, UserData.class));
        return userData;
    }

    @Override
    public UserData deleteBlacklisted(User blacklisted, Integer userDataId) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)blacklisted, Users.class);
        UserDatas userDatas = this.usersManagementService.deleteBlacklisted(users, userDataId);
        UserData userData = (UserData)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)userDatas, UserData.class));
        return userData;
    }

    @Override
    public void deleteResource(ResourcesModel resource, Integer userDataId) {
        this.usersManagementService.deleteResource(resource, userDataId);
    }

    @Override
    public boolean existsUserWithEmail(Contactmethod emailContact) {
        return this.usersManagementService.existsUserWithEmail((Contactmethods)MapperExtensions.map((Mapper)this.getMapper(), (Object)((Object)emailContact), Contactmethods.class));
    }

    public boolean existsUserWithEmail(String email) {
        return this.usersManagementService.existsUserWithEmail(email);
    }

    @Override
    public boolean existsUserWithEmailOrUsername(String emailOrUsername) {
        return this.usersManagementService.existsUserWithEmailOrUsername(emailOrUsername);
    }

    public InsertUserState existsUserWithEmailOrUsername(String email, String username) {
        return this.usersManagementService.existsUserWithEmailOrUsername(email, username);
    }

    public boolean existsUserWithUsername(String username) {
        return this.usersManagementService.existsUserWithUsername(username);
    }

    @Override
    public List<Address> findAddessesFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List addresses = this.usersManagementService.findAddessesFromUser(users);
        List addressDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)addresses, Address.class);
        return addressDomainObjects;
    }

    @Override
    public Address findAddressFromUser(User user) {
        Addresses addresses = this.usersManagementService.findAddressFromUser((Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class));
        Address address = (Address)MapperExtensions.map((Mapper)this.getMapper(), (Object)addresses, Address.class);
        return address;
    }

    @Override
    public List<Contactmethod> findAllEmailContactmethodsFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = this.usersManagementService.findAllEmailContactmethodsFromUser(users);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public List<Contactmethod> findAllFaxContactmethodsFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = this.usersManagementService.findAllFaxContactmethodsFromUser(users);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public List<Contactmethod> findAllInternetContactmethodsFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = this.usersManagementService.findAllInternetContactmethodsFromUser(users);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public List<Contactmethod> findAllMobileContactmethodsFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = this.usersManagementService.findAllMobileContactmethodsFromUser(users);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public List<Contactmethod> findAllTelefonContactmethodsFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = this.usersManagementService.findAllTelefonContactmethodsFromUser(users);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public Contactmethod findEmailContactFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.findEmailContactFromUser(users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public Contactmethod findFaxContactFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.findFaxContactFromUser(users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public Contactmethod findInternetContactFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.findInternetContactFromUser(users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public Contactmethod findMobileContactFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.findMobileContactFromUser(users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public List<Role> findRolesFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List roles = this.usersManagementService.findRolesFromUser(users);
        List roleDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)roles, Role.class);
        return roleDomainObjects;
    }

    @Override
    public Contactmethod findTelefonContactFromUser(User user) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.findTelefonContactFromUser(users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public User findUserWithEmail(String email) {
        Users users = this.usersManagementService.findUserWithEmail(email);
        return (User)MapperExtensions.map((Mapper)this.getMapper(), (Object)users, User.class);
    }

    @Override
    public User findUserWithEmailOrUsername(String emailOrUsername) {
        Users users = this.usersManagementService.findUserWithEmailOrUsername(emailOrUsername);
        return (User)MapperExtensions.map((Mapper)this.getMapper(), (Object)users, User.class);
    }

    @Override
    public User findUserWithUsername(String username) {
        Users users = this.usersManagementService.findUserWithUsername(username);
        return (User)MapperExtensions.map((Mapper)this.getMapper(), (Object)users, User.class);
    }

    public Mapper getMapper() {
        if (this.mapper == null) {
            this.mapper = this.newMapper(Collections.emptyList());
        }
        return this.mapper;
    }

    @Override
    public boolean isInRole(String rolename, List<Role> roles) {
        return this.usersManagementService.isInRole(rolename, MapperExtensions.map((Mapper)this.getMapper(), roles, Roles.class));
    }

    @Override
    public boolean isUserInRole(User user, String rolename) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        return this.usersManagementService.isUserInRole(users, rolename);
    }

    @Override
    public boolean isValid(String token) {
        return this.usersManagementService.isValid(token);
    }

    @Override
    public String newAuthenticationToken(String username) {
        return this.usersManagementService.newAuthenticationToken(username);
    }

    public Mapper newMapper(List<String> mappingFiles) {
        return new DozerBeanMapper(mappingFiles);
    }

    @Override
    public Resource persistResource(ResourcesModel resourceModel, Integer userId) {
        Resources resources = this.usersManagementService.persistResource(resourceModel, userId);
        Resource resource = (Resource)MapperExtensions.map((Mapper)this.getMapper(), (Object)resources, Resource.class);
        return resource;
    }

    @Override
    public void saveAddressesFromUser(User user, Collection<Address> addresses) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List addressEntities = MapperExtensions.map((Mapper)this.getMapper(), addresses, Addresses.class);
        this.usersManagementService.saveAddressesFromUser(users, (Collection)addressEntities);
    }

    @Override
    public void saveAddressFromUser(User user, Address address) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Addresses addressEntity = (Addresses)MapperExtensions.map((Mapper)this.getMapper(), (Object)address, Addresses.class);
        this.usersManagementService.saveAddressFromUser(users, addressEntity);
    }

    @Override
    public Serializable saveNewUser(User user) throws UserAlreadyExistsException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        return this.usersManagementService.saveNewUser(users);
    }

    @Override
    public Serializable saveUserOnlyWithEmail(User user) throws UserAlreadyExistsException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        return this.usersManagementService.saveUserOnlyWithEmail(users);
    }

    @Override
    public Contactmethod saveUserWithContactmethod(User user, Contactmethod contact) throws BatchUpdateException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = (Contactmethods)MapperExtensions.map((Mapper)this.getMapper(), (Object)((Object)contact), Contactmethods.class);
        contactmethods = this.usersManagementService.saveUserWithContactmethod(users, contactmethods);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public List<Contactmethod> saveUserWithContactmethods(User user, List<Contactmethod> contacts) throws BatchUpdateException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List contactmethods = MapperExtensions.map((Mapper)this.getMapper(), contacts, Contactmethods.class);
        contactmethods = this.usersManagementService.saveUserWithContactmethods(users, contactmethods);
        List contactmethodDomainObjects = MapperExtensions.map((Mapper)this.getMapper(), (Collection)contactmethods, Contactmethod.class);
        return contactmethodDomainObjects;
    }

    @Override
    public void saveUserWithRoles(User user, Collection<Role> roles) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        List roleEntities = MapperExtensions.map((Mapper)this.getMapper(), roles, Roles.class);
        this.usersManagementService.saveUserWithRoles(users, (Collection)roleEntities);
    }

    @Override
    public Contactmethod setEmail(String email, User user) throws EmailAlreadyExistsException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Contactmethods contactmethods = this.usersManagementService.setEmail(email, users);
        Contactmethod contactmethod = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethod;
    }

    @Override
    public boolean setUsername(String username, User user) throws UserAlreadyExistsException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        return this.usersManagementService.setUsername(username, users);
    }

    @Override
    public SignUpUserResult signUpUser(UsernameSignUpModel model, Set<Role> roles, UserModel userModel) {
        List roleEntities = MapperExtensions.map((Mapper)this.getMapper(), roles, Roles.class);
        return this.usersManagementService.signUpUser(model, new HashSet(roleEntities), userModel);
    }

    @Override
    public Contactmethod updateContactmethod(String contactmethodValue, ContactmethodType contactmethodType, Contactmethod contactmethod) {
        Contactmethods contactmethods = (Contactmethods)MapperExtensions.map((Mapper)this.getMapper(), (Object)((Object)contactmethod), Contactmethods.class);
        contactmethods = this.usersManagementService.updateContactmethod(contactmethodValue, contactmethodType, contactmethods);
        Contactmethod contactmethodDomainObject = (Contactmethod)((Object)MapperExtensions.map((Mapper)this.getMapper(), (Object)contactmethods, Contactmethod.class));
        return contactmethodDomainObject;
    }

    @Override
    public boolean updateUsername(String username, User user) throws UserAlreadyExistsException {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        return this.usersManagementService.updateUsername(username, users);
    }

    @Override
    public boolean userIsInRole(User user, Role role) {
        Users users = (Users)MapperExtensions.map((Mapper)this.getMapper(), (Object)user, Users.class);
        Roles roleEntity = (Roles)MapperExtensions.map((Mapper)this.getMapper(), (Object)role, Roles.class);
        return this.usersManagementService.userIsInRole(users, roleEntity);
    }

    @Override
    public ValidationErrors validate(UsernameSignUpModel model) {
        return this.usersManagementService.validate(model);
    }

    public UsersManagementService getUsersManagementService() {
        return this.usersManagementService;
    }

    public void setUsersManagementService(UsersManagementService usersManagementService) {
        this.usersManagementService = usersManagementService;
    }
}

