/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.address.book.domain.Address;
import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.enums.GenderType;
import de.alpharogroup.user.management.service.api.UserService;
import de.alpharogroup.user.management.service.api.UsersService;
import de.alpharogroup.user.mapper.UsersMapper;
import de.alpharogroup.user.repositories.UsersDao;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="userDomainService")
public class UserDomainService
extends AbstractDomainService<Integer, User, Users, UsersDao, UsersMapper>
implements UserService {
    @Autowired
    private UsersService usersService;

    @Override
    public boolean existsUserWithUsername(String username) {
        return this.usersService.existsUserWithUsername(username);
    }

    @Override
    public List<Address> findAddressesFromUser(User user) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        List addresses = this.usersService.findAddressesFromUser(users);
        List addresss = ((UsersMapper)this.getMapper()).map((Collection)addresses, Address.class);
        return addresss;
    }

    @Override
    public Address findAddressFromUser(User user) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        Addresses addresses = this.usersService.findAddressFromUser(users);
        Address addresss = (Address)((UsersMapper)this.getMapper()).map((Object)addresses, Address.class);
        return addresss;
    }

    @Override
    public List<Role> findRolesFromUser(User user) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        List roles = this.usersService.findRolesFromUser(users);
        List roless = ((UsersMapper)this.getMapper()).map((Collection)roles, Role.class);
        return roless;
    }

    @Override
    public List<User> findUsers(Integer from, GenderType searchGender, Integer until) {
        List users = this.usersService.findUsers(from, searchGender, until);
        List userss = ((UsersMapper)this.getMapper()).map((Collection)users, User.class);
        return userss;
    }

    @Override
    public List<User> findUsers(Integer from, GenderType searchGender, Integer until, String geohash) {
        List users = this.usersService.findUsers(from, searchGender, until, geohash);
        List userss = ((UsersMapper)this.getMapper()).map((Collection)users, User.class);
        return userss;
    }

    @Override
    public User findUserWithEmail(String email) {
        Users users = this.usersService.findUserWithEmail(email);
        User user = (User)((UsersMapper)this.getMapper()).toDomainObject((BaseEntity)users);
        return user;
    }

    @Override
    public User findUserWithUsername(String username) {
        Users users = this.usersService.findUserWithUsername(username);
        User user = (User)((UsersMapper)this.getMapper()).toDomainObject((BaseEntity)users);
        return user;
    }

    @Autowired
    public void setUsersDao(UsersDao usersDao) {
        this.setDao((EntityManagerDao)usersDao);
    }

    @Autowired
    public void setUsersMapper(UsersMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Override
    public boolean userIsInRole(User user, Role role) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        Roles roles = (Roles)((UsersMapper)this.getMapper()).map((Object)role, Roles.class);
        return this.usersService.userIsInRole(users, roles);
    }

    public UsersService getUsersService() {
        return this.usersService;
    }

    public void setUsersService(UsersService usersService) {
        this.usersService = usersService;
    }
}

