/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.application.models.InfringementModel;
import de.alpharogroup.user.management.daos.RuleViolationsDao;
import de.alpharogroup.user.management.domain.RuleViolation;
import de.alpharogroup.user.management.domain.model.Infringement;
import de.alpharogroup.user.management.entities.RuleViolations;
import de.alpharogroup.user.management.enums.RuleViolationReason;
import de.alpharogroup.user.management.mapper.RuleViolationsMapper;
import de.alpharogroup.user.management.service.api.RuleViolationService;
import de.alpharogroup.user.management.service.api.RuleViolationsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="ruleViolationDomainService")
public class RuleViolationDomainService
extends AbstractDomainService<Integer, RuleViolation, RuleViolations, RuleViolationsDao, RuleViolationsMapper>
implements RuleViolationService {
    @Autowired
    private RuleViolationsService ruleViolationsService;

    @Override
    public List<RuleViolation> find(User detector, User violator, RuleViolationReason reason, String description) {
        Users detectors = (Users)((RuleViolationsMapper)this.getMapper()).map(detector, Users.class);
        Users violators = (Users)((RuleViolationsMapper)this.getMapper()).map(violator, Users.class);
        List ruleViolations = this.ruleViolationsService.find(detectors, violators, reason, description);
        return ((RuleViolationsMapper)this.getMapper()).toDomainObjects(ruleViolations);
    }

    @Override
    public RuleViolation save(Infringement model) {
        InfringementModel infringementModel = this.toInfringementModel(model);
        RuleViolations ruleViolations = this.ruleViolationsService.save(infringementModel);
        return (RuleViolation)((RuleViolationsMapper)this.getMapper()).toDomainObject((BaseEntity)ruleViolations);
    }

    @Override
    @Deprecated
    public RuleViolation save(InfringementModel model) {
        RuleViolations ruleViolations = this.ruleViolationsService.save(model);
        return (RuleViolation)((RuleViolationsMapper)this.getMapper()).toDomainObject((BaseEntity)ruleViolations);
    }

    @Autowired
    public void setRuleViolationsDao(RuleViolationsDao ruleViolationsDao) {
        this.setDao((EntityManagerDao)ruleViolationsDao);
    }

    @Autowired
    public void setRuleViolationsMapper(RuleViolationsMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    private InfringementModel toInfringementModel(Infringement model) {
        return InfringementModel.builder().violator((Users)((RuleViolationsMapper)this.getMapper()).map(model.getViolator(), Users.class)).detector((Users)((RuleViolationsMapper)this.getMapper()).map(model.getDetector(), Users.class)).description(model.getDescription()).reason(model.getReason()).build();
    }

    public RuleViolationsService getRuleViolationsService() {
        return this.ruleViolationsService;
    }

    public void setRuleViolationsService(RuleViolationsService ruleViolationsService) {
        this.ruleViolationsService = ruleViolationsService;
    }
}

