/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.daos.RecommendationsDao;
import de.alpharogroup.user.management.domain.Recommendation;
import de.alpharogroup.user.management.entities.Recommendations;
import de.alpharogroup.user.management.mapper.RecommendationsMapper;
import de.alpharogroup.user.management.service.api.RecommendationService;
import de.alpharogroup.user.management.service.api.RecommendationsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="recommendationDomainService")
public class RecommendationDomainService
extends AbstractDomainService<Integer, Recommendation, Recommendations, RecommendationsDao, RecommendationsMapper>
implements RecommendationService {
    @Autowired
    private RecommendationsService recommendationsService;

    @Override
    public List<Recommendation> find(User user, User recommended, String email) {
        Users users = (Users)((RecommendationsMapper)this.getMapper()).map(user, Users.class);
        Users recommendeds = (Users)((RecommendationsMapper)this.getMapper()).map(recommended, Users.class);
        List recommendations = this.recommendationsService.find(users, recommendeds, email);
        return ((RecommendationsMapper)this.getMapper()).toDomainObjects(recommendations);
    }

    @Override
    public Recommendation findRecommendations(User user, User recommended, String email) {
        Users users = (Users)((RecommendationsMapper)this.getMapper()).map(user, Users.class);
        Users recommendeds = (Users)((RecommendationsMapper)this.getMapper()).map(recommended, Users.class);
        return (Recommendation)((RecommendationsMapper)this.getMapper()).toDomainObject((BaseEntity)this.recommendationsService.findRecommendations(users, recommendeds, email));
    }

    @Autowired
    public void setRecommendationsDao(RecommendationsDao recommendationsDao) {
        this.setDao((EntityManagerDao)recommendationsDao);
    }

    @Autowired
    public void setRecommendationsMapper(RecommendationsMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    public RecommendationsService getRecommendationsService() {
        return this.recommendationsService;
    }

    public void setRecommendationsService(RecommendationsService recommendationsService) {
        this.recommendationsService = recommendationsService;
    }
}

