/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.auth.models.AuthenticationErrors;
import de.alpharogroup.auth.models.AuthenticationResult;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.management.service.api.AuthenticationService;
import de.alpharogroup.user.management.service.api.AuthenticationsService;
import de.alpharogroup.user.mapper.UsersMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="authenticationDomainService")
public class AuthenticationDomainService
implements AuthenticationService {
    @Autowired
    private AuthenticationsService authenticationsService;
    private final UsersMapper mapper = new UsersMapper();

    @Override
    public AuthenticationResult<User, AuthenticationErrors> authenticate(String emailOrUsername, String password) {
        AuthenticationResult originalAuthenticationResult = this.authenticationsService.authenticate(emailOrUsername, password);
        AuthenticationResult authenticationResult = AuthenticationResult.builder().validationErrors(originalAuthenticationResult.getValidationErrors()).user((Object)this.mapper.toDomainObject((BaseEntity)originalAuthenticationResult.getUser())).build();
        return authenticationResult;
    }

    @Override
    public String newAuthenticationToken(String username) {
        return this.authenticationsService.newAuthenticationToken(username);
    }

    public AuthenticationsService getAuthenticationsService() {
        return this.authenticationsService;
    }

    public void setAuthenticationsService(AuthenticationsService authenticationsService) {
        this.authenticationsService = authenticationsService;
    }
}

