/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.sign.in;

import de.alpharogroup.user.management.entities.Users;
import de.alpharogroup.user.management.service.api.UsersManagementService;
import de.alpharogroup.user.management.sign.in.AuthenticationErrors;
import de.alpharogroup.user.management.sign.in.AuthenticationResult;

public abstract class AbstractAuthenticationService {
    public AuthenticationResult<Users, AuthenticationErrors> authenticate(String email, String password) {
        AuthenticationResult<Users, AuthenticationErrors> authenticationResult = new AuthenticationResult<Users, AuthenticationErrors>();
        UsersManagementService userManagementBusinessService = this.getUserManagementService();
        boolean emailExists = userManagementBusinessService.existsUserWithEmail(email);
        if (emailExists) {
            Users user = userManagementBusinessService.findUserWithEmail(email);
            return this.authorize(user, password, authenticationResult);
        }
        boolean usernameExists = userManagementBusinessService.existsUserWithUsername(email);
        if (usernameExists) {
            Users user = userManagementBusinessService.findUserWithUsername(email);
            return this.authorize(user, password, authenticationResult);
        }
        authenticationResult.getValidationErrors().add(AuthenticationErrors.EMAIL_OR_USERNAME_DOES_NOT_EXIST);
        return authenticationResult;
    }

    protected AuthenticationResult<Users, AuthenticationErrors> authorize(Users user, String password, AuthenticationResult<Users, AuthenticationErrors> authenticationResult) {
        if (user.isActive()) {
            String pw = user.getPw();
            if (password.equals(pw)) {
                authenticationResult.setUser(user);
            } else {
                authenticationResult.getValidationErrors().add(AuthenticationErrors.PASSWORD_INVALID);
            }
        } else {
            authenticationResult.getValidationErrors().add(AuthenticationErrors.UNREGISTERED);
        }
        return authenticationResult;
    }

    public abstract UsersManagementService getUserManagementService();
}

