/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.address.book.service.util.HqlStringCreator;
import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.jgeohash.GeoHashExtensions;
import de.alpharogroup.user.management.daos.UsersDao;
import de.alpharogroup.user.management.entities.Roles;
import de.alpharogroup.user.management.entities.Users;
import de.alpharogroup.user.management.enums.GenderType;
import de.alpharogroup.user.management.service.api.UsersService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="usersService")
public class UsersBusinessService
extends AbstractBusinessService<Users, Integer, UsersDao>
implements UsersService {
    private static final Logger LOGGER = Logger.getLogger((String)UsersBusinessService.class.getName());
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setUsersDao(UsersDao usersDao) {
        this.setDao((EntityManagerDao)usersDao);
    }

    @Override
    public boolean existsUserWithUsername(String username) {
        Users users = this.findUserWithUsername(username);
        return users != null;
    }

    @Override
    public List<Addresses> findAddressesFromUser(Users user) {
        String hqlString = "select ur.address from UserAddresses ur where ur.user=:user";
        Query query = this.getQuery("select ur.address from UserAddresses ur where ur.user=:user");
        query.setParameter("user", (Object)user);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public Addresses findAddressFromUser(Users user) {
        List<Addresses> addresses = this.findAddressesFromUser(user);
        if (null != addresses && !addresses.isEmpty()) {
            return addresses.get(0);
        }
        return null;
    }

    @Override
    public List<Roles> findRolesFromUser(Users user) {
        String hqlString = "select u.roles from Users u where u=:user";
        Query query = this.getQuery("select u.roles from Users u where u=:user");
        query.setParameter("user", (Object)user);
        List roles = query.getResultList();
        return roles;
    }

    @Override
    @Transactional
    public Users findUserWithEmail(String email) {
        String hqlString = "select u from Users u inner join u.userData.contactmethods cc where cc.contactmethod='EMAIL' and cc.contactmethod.contactvalue=:email";
        Query query = this.getQuery("select u from Users u inner join u.userData.contactmethods cc where cc.contactmethod='EMAIL' and cc.contactmethod.contactvalue=:email");
        query.setParameter("email", (Object)email);
        List users = query.getResultList();
        return (Users)ListExtensions.getFirst((List)users);
    }

    @Override
    public Users findUserWithUsername(String username) {
        String hqlString = "select u from Users u where u.username=:username";
        Query query = this.getQuery("select u from Users u where u.username=:username");
        query.setParameter("username", (Object)username);
        List users = query.getResultList();
        return (Users)ListExtensions.getFirst((List)users);
    }

    @Override
    public boolean userIsInRole(Users user, Roles role) {
        List<Roles> roles = this.findRolesFromUser(user);
        return null != roles && !roles.isEmpty() && roles.contains(role);
    }

    @Override
    public List<Users> findUsers(Integer from, GenderType searchGender, Integer until) {
        Date now = new Date(System.currentTimeMillis());
        Date start = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)until);
        Date end = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)from);
        String hqlString = "select u from Users u where u.userData.gender=:gender and u.userData.dateofbirth >= :start and u.userData.dateofbirth <= :end";
        Query query = this.getQuery("select u from Users u where u.userData.gender=:gender and u.userData.dateofbirth >= :start and u.userData.dateofbirth <= :end");
        query.setParameter("gender", (Object)searchGender);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        List users = query.getResultList();
        return users;
    }

    @Override
    public List<Users> findUsers(Integer from, GenderType searchGender, Integer until, String geohash) {
        Date now = new Date(System.currentTimeMillis());
        Date start = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)until);
        Date end = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)from);
        StringBuilder hqlString = new StringBuilder();
        hqlString.append("select u from Users u where u.userData.gender=:gender and u.userData.dateofbirth >= :start and u.userData.dateofbirth <= :end ");
        Map adjacentAreas = null;
        if (geohash != null && !geohash.trim().isEmpty()) {
            adjacentAreas = GeoHashExtensions.getTwentyFiveAreasMap((String)geohash);
        }
        if (adjacentAreas != null) {
            String firstAndSecondRingSubQuery = HqlStringCreator.getGeohashFirstAndSecondRingSubQuery();
            hqlString.append("and u.userData.primaryAddress.geohash in " + firstAndSecondRingSubQuery);
        }
        String queryString = hqlString.toString();
        LOGGER.info((Object)("Query String from method findUsers:" + queryString));
        Query query = this.getQuery(queryString);
        query.setParameter("gender", (Object)searchGender);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        if (adjacentAreas != null) {
            for (Map.Entry entry : adjacentAreas.entrySet()) {
                query.setParameter((String)entry.getKey(), (Object)((String)entry.getValue() + "%"));
            }
        }
        List users = query.getResultList();
        return users;
    }
}

