/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.application.models.InfringementModel;
import de.alpharogroup.user.management.daos.RuleViolationsDao;
import de.alpharogroup.user.management.entities.RuleViolations;
import de.alpharogroup.user.management.entities.Users;
import de.alpharogroup.user.management.enums.RuleViolationReason;
import de.alpharogroup.user.management.factories.UserManagementFactory;
import de.alpharogroup.user.management.service.api.RuleViolationsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="ruleViolationsService")
public class RuleViolationsBusinessService
extends AbstractBusinessService<RuleViolations, Integer, RuleViolationsDao>
implements RuleViolationsService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setRuleViolationsDao(RuleViolationsDao ruleViolationsDao) {
        this.setDao((EntityManagerDao)ruleViolationsDao);
    }

    @Override
    public RuleViolations save(InfringementModel model) {
        RuleViolations ruleViolations = UserManagementFactory.getInstance().newRuleViolations(model.getDetector(), model.getViolator(), model.getDescription(), model.getReason());
        return (RuleViolations)this.merge((BaseEntity)ruleViolations);
    }

    @Override
    public List<RuleViolations> find(Users detector, Users violator, RuleViolationReason reason, String description) {
        String hqlString = HqlStringCreator.forRuleViolations(detector, violator, reason, description);
        Query query = this.getQuery(hqlString);
        if (detector != null) {
            query.setParameter("detector", (Object)detector);
        }
        if (violator != null) {
            query.setParameter("violator", (Object)violator);
        }
        if (reason != null) {
            query.setParameter("reason", (Object)reason);
        }
        if (description != null && !description.isEmpty()) {
            query.setParameter("description", (Object)description);
        }
        List ruleViolations = query.getResultList();
        return ruleViolations;
    }
}

