/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.daos.RolesDao;
import de.alpharogroup.user.management.entities.Permissions;
import de.alpharogroup.user.management.entities.Roles;
import de.alpharogroup.user.management.factories.UserManagementFactory;
import de.alpharogroup.user.management.service.api.RolesService;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="rolesService")
public class RolesBusinessService
extends AbstractBusinessService<Roles, Integer, RolesDao>
implements RolesService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setRolesDao(RolesDao rolesDao) {
        this.setDao((EntityManagerDao)rolesDao);
    }

    @Override
    public List<Permissions> findAllPermissions(Roles role) {
        String hqlString = "select rp.permission from RolePermissions rp where rp.role=:role";
        Query query = this.getQuery("select rp.permission from RolePermissions rp where rp.role=:role");
        query.setParameter("role", (Object)role);
        List permissions = query.getResultList();
        return permissions;
    }

    @Override
    public Roles createAndSaveRole(String rolename, String description) {
        return this.createAndSaveRole(rolename, description, null);
    }

    @Override
    public Roles createAndSaveRole(String rolename, String description, Set<Permissions> permissions) {
        Roles role = this.findRole(rolename);
        if (role == null) {
            role = UserManagementFactory.getInstance().newRoles(rolename, description, permissions);
            role = (Roles)this.merge((BaseEntity)role);
        }
        return role;
    }

    @Override
    public Roles findRole(String rolename) {
        return (Roles)ListExtensions.getFirst(this.findRoles(rolename));
    }

    @Override
    public List<Roles> findRoles(String rolename) {
        String hqlString = "select r from Roles r where r.rolename=:rolename";
        Query query = this.getQuery("select r from Roles r where r.rolename=:rolename");
        query.setParameter("rolename", (Object)rolename);
        List roles = query.getResultList();
        return roles;
    }

    @Override
    public boolean exists(String rolename) {
        return this.findRole(rolename) != null;
    }
}

