/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.daos.ResetPasswordsDao;
import de.alpharogroup.user.management.entities.ResetPasswords;
import de.alpharogroup.user.management.entities.Users;
import de.alpharogroup.user.management.service.api.ResetPasswordsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="resetPasswordsService")
public class ResetPasswordsBusinessService
extends AbstractBusinessService<ResetPasswords, Integer, ResetPasswordsDao>
implements ResetPasswordsService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setResetPasswordsDao(ResetPasswordsDao resetPasswordsDao) {
        this.setDao((EntityManagerDao)resetPasswordsDao);
    }

    @Override
    public ResetPasswords findResetPassword(Users user) {
        return (ResetPasswords)ListExtensions.getFirst(this.find(user, null, null, null));
    }

    @Override
    public ResetPasswords findResetPassword(Users user, String generatedPassword) {
        return (ResetPasswords)ListExtensions.getFirst(this.find(user, generatedPassword, null, null));
    }

    public List<ResetPasswords> find(Users user, String generatedPassword, Date expiryDate, Date starttime) {
        String hqlString = HqlStringCreator.forResetPasswords(user, generatedPassword, expiryDate, starttime);
        Query query = this.getQuery(hqlString);
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (generatedPassword != null) {
            query.setParameter("generatedPassword", (Object)generatedPassword);
        }
        if (expiryDate != null) {
            query.setParameter("expiryDate", (Object)expiryDate);
        }
        if (starttime != null) {
            query.setParameter("starttime", (Object)starttime);
        }
        List resetPasswords = query.getResultList();
        return resetPasswords;
    }
}

