/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.daos.RelationPermissionsDao;
import de.alpharogroup.user.management.entities.Permissions;
import de.alpharogroup.user.management.entities.RelationPermissions;
import de.alpharogroup.user.management.entities.Users;
import de.alpharogroup.user.management.factories.UserManagementFactory;
import de.alpharogroup.user.management.service.api.RelationPermissionsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="relationPermissionsService")
public class RelationPermissionsBusinessService
extends AbstractBusinessService<RelationPermissions, Integer, RelationPermissionsDao>
implements RelationPermissionsService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setRelationPermissionsDao(RelationPermissionsDao relationPermissionsDao) {
        this.setDao((EntityManagerDao)relationPermissionsDao);
    }

    @Override
    public RelationPermissions findRelationPermissions(Users provider, Users subscriber) {
        return (RelationPermissions)ListExtensions.getFirst(this.find(provider, subscriber));
    }

    @Override
    public RelationPermissions findRelationPermissions(Users provider, Users subscriber, Permissions permission) {
        return (RelationPermissions)ListExtensions.getFirst(this.find(provider, subscriber, permission));
    }

    @Override
    public List<RelationPermissions> find(Users provider, Users subscriber) {
        return this.find(provider, subscriber, null);
    }

    @Override
    public List<RelationPermissions> find(Users provider, Users subscriber, Permissions permission) {
        String hqlString = HqlStringCreator.forRelationPermissions(provider, subscriber, permission);
        Query query = this.getQuery(hqlString);
        if (provider != null) {
            query.setParameter("provider", (Object)provider);
        }
        if (subscriber != null) {
            query.setParameter("subscriber", (Object)subscriber);
        }
        if (permission != null) {
            query.setParameter("permission", (Object)permission);
        }
        List list = query.getResultList();
        return list;
    }

    @Override
    public void addPermission(Users provider, Users subscriber, Permissions permission) {
        RelationPermissions rp = this.findRelationPermissions(provider, subscriber, permission);
        if (rp == null) {
            rp = this.findRelationPermissions(provider, subscriber);
            if (rp == null) {
                rp = UserManagementFactory.getInstance().newRelationPermissions(provider, subscriber);
            }
            rp.getPermissions().add(permission);
            this.merge((BaseEntity)rp);
        }
    }

    @Override
    public void removePermission(Users provider, Users subscriber, Permissions permission) {
        RelationPermissions rp = this.findRelationPermissions(provider, subscriber, permission);
        if (rp != null) {
            rp.getPermissions().remove(permission);
            this.merge((BaseEntity)rp);
        }
    }

    @Override
    public void removeAllPermissions(Users provider, Users subscriber) {
        RelationPermissions relationPermissions = this.findRelationPermissions(provider, subscriber);
        if (relationPermissions != null) {
            relationPermissions.setProvider(null);
            relationPermissions.setSubscriber(null);
            relationPermissions = (RelationPermissions)this.merge((BaseEntity)relationPermissions);
            this.delete((BaseEntity)relationPermissions);
        }
        if ((relationPermissions = this.findRelationPermissions(subscriber, provider)) != null) {
            relationPermissions.setProvider(null);
            relationPermissions.setSubscriber(null);
            relationPermissions = (RelationPermissions)this.merge((BaseEntity)relationPermissions);
            this.delete((BaseEntity)relationPermissions);
        }
    }
}

